/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.commands;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.laboratory.dialogs.EditLabItem;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class EditLabItemUi
extends AbstractHandler {
    public static final String COMMANDID = "ch.elexis.labitem.edit";
    public static final String PARAMETERID = "ch.elexis.labitem.edit.selected";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            String param = event.getParameter(PARAMETERID);
            Optional labitem = StoreToStringServiceHolder.get().loadFromString(param);
            if (labitem.isPresent() && labitem.get() instanceof ILabItem) {
                Shell parent = HandlerUtil.getActiveShell((ExecutionEvent)event);
                EditLabItem dialog = new EditLabItem(parent, (ILabItem)labitem.get());
                dialog.open();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(COMMANDID, ex);
        }
        return null;
    }

    public static void executeWithParams(Identifiable identifiable) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            ICommandService cmdService = (ICommandService)window.getService(ICommandService.class);
            Command cmd = cmdService.getCommand(COMMANDID);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put(PARAMETERID, StoreToStringServiceHolder.get().storeToString(identifiable).orElse(null));
            ParameterizedCommand pc = ParameterizedCommand.generateCommand((Command)cmd, param);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            handlerService.executeCommand(pc, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(COMMANDID, ex);
        }
    }
}

