/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.laboratory.actions.LabOrderSetObservationDateAction;
import ch.elexis.core.ui.laboratory.actions.LaborResultEditDetailAction;
import ch.elexis.core.ui.laboratory.actions.LaborResultOrderDeleteAction;
import ch.elexis.core.ui.laboratory.controls.LaborOrderViewerItem;
import ch.elexis.core.ui.laboratory.controls.Messages;
import ch.elexis.core.ui.laboratory.controls.util.LabOrderEditingSupport;
import ch.elexis.data.LabOrder;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaborOrdersComposite
extends Composite {
    private final FormToolkit tk = UiDesk.getToolkit();
    private Form form;
    private TableViewer viewer;
    private int sortColumn = -1;
    private boolean revert = false;
    private boolean reloadPending;
    private boolean includeDone;
    private Patient actPatient;
    private Composite toolComposite;
    private ToolBarManager toolbar;
    public static final String OUTPUTLOG_EXTERNES_LABOR = "Externes Labor";

    public LaborOrdersComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
        this.selectPatient(ElexisEventDispatcher.getSelectedPatient());
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        this.form = this.tk.createForm((Composite)this);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.toolComposite = new Composite(body, 0);
        this.toolComposite.setLayout((Layout)new FillLayout(512));
        this.toolComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.toolbar = new ToolBarManager();
        this.toolbar.add((IAction)new Action("", 2){

            public String getText() {
                return Messages.LaborOrdersComposite_actionTooltipShowHistory;
            }

            public String getToolTipText() {
                return Messages.LaborOrdersComposite_actionTooltipShowHistory;
            }

            public void run() {
                LaborOrdersComposite.this.setIncludeDone(!LaborOrdersComposite.this.includeDone);
            }
        });
        this.tk.adapt((Composite)this.toolbar.createControl(this.toolComposite));
        this.tk.adapt(this.toolComposite);
        this.viewer = new TableViewer(body, 268501762);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setSorter((ViewerSorter)new LaborOrdersSorter(this));
        final MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List orders;
                IStructuredSelection selection = (IStructuredSelection)LaborOrdersComposite.this.viewer.getSelection();
                if (selection != null && !selection.isEmpty() && !(orders = selection.toList()).isEmpty()) {
                    mgr.add((IAction)new LabOrderSetObservationDateAction(orders, (StructuredViewer)LaborOrdersComposite.this.viewer));
                    mgr.add((IAction)new LaborResultEditDetailAction(orders, (StructuredViewer)LaborOrdersComposite.this.viewer));
                    mgr.add((IAction)new LaborResultOrderDeleteAction(orders, (StructuredViewer)LaborOrdersComposite.this.viewer));
                }
            }
        });
        this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(28);
        column.getColumn().setText("");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    IOutputLog log;
                    LaborOrderViewerItem item = (LaborOrderViewerItem)element;
                    ILabOrder order = CoreModelServiceHolder.get().load(item.getLabOrder().getId(), ILabOrder.class).orElse(null);
                    if (order != null && (log = LaborOrdersComposite.getOrderLogEntry(order)) != null && LaborOrdersComposite.OUTPUTLOG_EXTERNES_LABOR.equals(log.getOutputterStatus())) {
                        return Images.IMG_BLOOD_TEST.getImage();
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText(Messages.Core_Status);
        column.getColumn().addSelectionListener((SelectionListener)new LaborOrdersSortSelection(0, this));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    return LabOrder.getStateLabel((LabOrder.State)((LaborOrderViewerItem)element).getState());
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(125);
        column.getColumn().setText(Messages.Core_Date);
        column.getColumn().addSelectionListener((SelectionListener)new LaborOrdersSortSelection(1, this));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    TimeTool time = ((LaborOrderViewerItem)element).getTime();
                    if (time != null) {
                        return time.toString(0);
                    }
                    return "???";
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(140);
        column.getColumn().setText(Messages.LaborOrdersComposite_columnObservationTime);
        column.getColumn().addSelectionListener((SelectionListener)new LaborOrdersSortSelection(1, this));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    TimeTool time = ((LaborOrderViewerItem)element).getObservationTime();
                    if (time != null) {
                        return time.toString(0);
                    }
                    return "???";
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(75);
        column.getColumn().setText(Messages.Order_ID);
        column.getColumn().addSelectionListener((SelectionListener)new LaborOrdersSortSelection(2, this));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    return ((LaborOrderViewerItem)element).getOrderId().orElse("");
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(75);
        column.getColumn().setText(Messages.Core_Group);
        column.getColumn().addSelectionListener((SelectionListener)new LaborOrdersSortSelection(3, this));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    return ((LaborOrderViewerItem)element).getOrderGroupName().orElse("");
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setText(Messages.Core_Parameter);
        column.getColumn().addSelectionListener((SelectionListener)new LaborOrdersSortSelection(4, this));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    return ((LaborOrderViewerItem)element).getLabItemLabel().orElse("");
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(75);
        column.getColumn().setText(Messages.Core_Value);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LaborOrderViewerItem) {
                    return ((LaborOrderViewerItem)element).getLabResultString().orElse("?");
                }
                return "";
            }
        });
        column.setEditingSupport((EditingSupport)new LabOrderEditingSupport((ColumnViewer)this.viewer));
        this.form.setText(Messages.Core_No_patient_selected);
    }

    public void selectPatient(Patient patient) {
        this.setRedraw(false);
        if (patient != null) {
            if (!patient.equals((Object)this.actPatient)) {
                this.actPatient = patient;
                this.form.setText(this.actPatient.getLabel());
                this.reload();
            }
        } else {
            this.actPatient = patient;
            this.form.setText(Messages.Core_No_patient_selected);
        }
        this.setRedraw(true);
    }

    public void setIncludeDone(boolean value) {
        if (value != this.includeDone) {
            this.includeDone = value;
            this.reload();
        }
    }

    public void reload() {
        if (!this.isVisible()) {
            this.reloadPending = true;
            return;
        }
        this.setRedraw(false);
        this.reloadPending = false;
        if (this.actPatient != null) {
            this.viewer.setInput(this.getOrders());
        }
        this.setRedraw(true);
    }

    public boolean setFocus() {
        if (this.reloadPending) {
            this.reload();
        }
        return super.setFocus();
    }

    private List<LaborOrderViewerItem> getOrders() {
        if (this.actPatient != null) {
            List orders = null;
            orders = ConfigServiceHolder.getUser((String)"lab/showMandantOnly", (boolean)false) ? LabOrder.getLabOrders((String)this.actPatient.getId(), (String)ContextServiceHolder.getActiveMandatorOrNull().getId(), null, null, null, null, (LabOrder.State)(this.includeDone ? null : LabOrder.State.ORDERED)) : LabOrder.getLabOrders((Patient)this.actPatient, null, null, null, null, null, (LabOrder.State)(this.includeDone ? null : LabOrder.State.ORDERED));
            if (orders != null) {
                ArrayList<LaborOrderViewerItem> viewerItems = new ArrayList<LaborOrderViewerItem>();
                orders.forEach(order -> {
                    boolean bl = viewerItems.add(new LaborOrderViewerItem((StructuredViewer)this.viewer, (LabOrder)order));
                });
                Collections.sort(viewerItems, new Comparator<LaborOrderViewerItem>(){

                    @Override
                    public int compare(LaborOrderViewerItem lo1, LaborOrderViewerItem lo2) {
                        String prio1 = lo1.getLabItemPrio().orElse("");
                        String prio2 = lo2.getLabItemPrio().orElse("");
                        return prio1.compareTo(prio2);
                    }
                });
                return viewerItems;
            }
        }
        return Collections.emptyList();
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public boolean isRevert() {
        return this.revert;
    }

    public void setRevert(boolean revert) {
        this.revert = revert;
    }

    public static IOutputLog getOrderLogEntry(ILabOrder order) {
        if (order == null) {
            return null;
        }
        IQuery query = CoreModelServiceHolder.get().getQuery(IOutputLog.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IOUTPUT_LOG__OBJECT_ID, IQuery.COMPARATOR.EQUALS, (Object)order.getId());
        return query.execute().isEmpty() ? null : (IOutputLog)query.execute().get(0);
    }

    private static class LaborOrdersSortSelection
    extends SelectionAdapter {
        private int columnIndex;
        private LaborOrdersComposite composite;

        public LaborOrdersSortSelection(int columnIndex, LaborOrdersComposite composite) {
            this.columnIndex = columnIndex;
            this.composite = composite;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.composite.getSortColumn() == this.columnIndex) {
                this.composite.setRevert(!this.composite.isRevert());
            } else {
                this.composite.setRevert(false);
            }
            this.composite.setSortColumn(this.columnIndex);
            this.composite.getViewer().refresh();
        }
    }

    private static class LaborOrdersSorter
    extends ViewerSorter {
        private LaborOrdersComposite composite;

        public LaborOrdersSorter(LaborOrdersComposite composite) {
            this.composite = composite;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof LaborOrderViewerItem && e2 instanceof LaborOrderViewerItem) {
                LaborOrderViewerItem labOrder1 = (LaborOrderViewerItem)e1;
                LaborOrderViewerItem labOrder2 = (LaborOrderViewerItem)e2;
                switch (this.composite.getSortColumn()) {
                    case 0: {
                        if (this.composite.isRevert()) {
                            return labOrder1.getState().name().compareTo(labOrder2.getState().name());
                        }
                        return labOrder2.getState().name().compareTo(labOrder1.getState().name());
                    }
                    case 1: {
                        if (this.composite.isRevert()) {
                            return labOrder1.getTime().compareTo((Calendar)labOrder2.getTime());
                        }
                        return labOrder2.getTime().compareTo((Calendar)labOrder1.getTime());
                    }
                    case 2: {
                        String orderId1 = labOrder1.getOrderId().orElse("");
                        String orderId2 = labOrder2.getOrderId().orElse("");
                        if (this.composite.isRevert()) {
                            try {
                                return Integer.decode(orderId1).compareTo(Integer.decode(orderId2));
                            }
                            catch (NumberFormatException numberFormatException) {
                                return orderId1.compareTo(orderId2);
                            }
                        }
                        try {
                            return Integer.decode(orderId2).compareTo(Integer.decode(orderId1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            return orderId2.compareTo(orderId1);
                        }
                    }
                    case 3: {
                        if (this.composite.isRevert()) {
                            return labOrder1.getOrderGroupName().orElse("").compareTo(labOrder2.getOrderGroupName().orElse(""));
                        }
                        return labOrder2.getOrderGroupName().orElse("").compareTo(labOrder1.getOrderGroupName().orElse(""));
                    }
                    case 4: {
                        if (this.composite.isRevert()) {
                            return labOrder1.getLabItemLabel().orElse("").compareTo(labOrder2.getLabItemLabel().orElse(""));
                        }
                        return labOrder2.getLabItemLabel().orElse("").compareTo(labOrder1.getLabItemLabel().orElse(""));
                    }
                }
                int timeCompare = labOrder2.getTime().compareTo((Calendar)labOrder1.getTime());
                if (timeCompare == 0) {
                    String prio1 = labOrder1.getLabItemPrio().orElse("");
                    String prio2 = labOrder2.getLabItemPrio().orElse("");
                    if (StringUtils.isNumeric((CharSequence)prio1) && StringUtils.isNumeric((CharSequence)prio2)) {
                        try {
                            return Integer.valueOf(prio1).compareTo(Integer.valueOf(prio2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return prio1.compareTo(prio2);
                }
                return timeCompare;
            }
            return 0;
        }
    }
}

