/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls.util;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class LaborResultsLabelProvider
extends ColumnLabelProvider {
    private TreeViewerColumn column;

    public LaborResultsLabelProvider(TreeViewerColumn column) {
        this.column = column;
    }

    public String getText(Object element) {
        List<LabResult> results;
        TimeTool date;
        if (element instanceof LaborItemResults && (date = (TimeTool)this.column.getColumn().getData("labresult.date")) != null && (results = ((LaborItemResults)element).getResult(date.toString(9))) != null) {
            StringBuilder sb = new StringBuilder();
            for (LabResult labResult : results) {
                if (sb.length() == 0) {
                    sb.append(this.getResultString(labResult));
                    continue;
                }
                sb.append(" / ");
                sb.append(this.getResultString(labResult));
            }
            return sb.toString();
        }
        return "";
    }

    private String getResultString(LabResult labResult) {
        if (labResult.getItem().getTyp() == LabItemTyp.DOCUMENT) {
            return Messages.Core_Open;
        }
        if (labResult.getItem().getTyp() == LabItemTyp.TEXT) {
            return this.getNonEmptyResultString(labResult);
        }
        int digits = labResult.getItem().getDigits();
        String result = this.getNonEmptyResultString(labResult);
        if (digits == 0) {
            return result;
        }
        try {
            Float resultNumeric = Float.valueOf(Float.parseFloat(result));
            return String.format("%." + digits + "f", resultNumeric);
        }
        catch (NumberFormatException e) {
            return result;
        }
    }

    private String getPathologicString(LabResult labResult) {
        PathologicDescription pathologicDescription = labResult.getPathologicDescription();
        StringBuilder sb = new StringBuilder();
        if (labResult.isFlag(1)) {
            sb.append("pathologisch");
        } else if (labResult.isPathologicFlagIndetermined(pathologicDescription)) {
            sb.append("nicht bestimmt");
        } else {
            sb.append("nicht pathologisch");
        }
        if (pathologicDescription != null && pathologicDescription.getDescription() != PathologicDescription.Description.UNKNOWN) {
            sb.append(" - ").append(pathologicDescription.getLabel());
        }
        return sb.toString();
    }

    private String getNonEmptyResultString(LabResult labResult) {
        String result = labResult.getResult();
        if (result != null && result.isEmpty()) {
            result = "?";
        }
        if (labResult.getItem().getTyp() == LabItemTyp.TEXT && labResult.isLongText() && (result = labResult.getComment()).length() > 20) {
            result = result.substring(0, 20);
        }
        return result;
    }

    private String getUnitAndReferenceString(LabResult labResult) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(labResult.getUnit()).append("]");
        if (labResult.getPatient().getGeschlecht().equals("m")) {
            sb.append("[").append(labResult.getRefMale()).append("]");
        } else {
            sb.append("[").append(labResult.getRefFemale()).append("]");
        }
        return sb.toString();
    }

    private String getCommentString(LabResult labResult) {
        StringBuilder sb = new StringBuilder();
        String comment = labResult.getComment();
        if (!comment.isEmpty()) {
            sb.append("\n").append(comment);
        }
        return sb.toString();
    }

    public String getToolTipText(Object element) {
        List<LabResult> results;
        TimeTool date;
        if (element instanceof LaborItemResults && (date = (TimeTool)this.column.getColumn().getData("labresult.date")) != null && (results = ((LaborItemResults)element).getResult(date.toString(9))) != null) {
            StringBuilder sb = new StringBuilder();
            for (LabResult labResult : results) {
                TimeTool time = labResult.getObservationTime();
                if (time == null) {
                    time = labResult.getDateTime();
                }
                if (sb.length() == 0) {
                    sb.append(time.toString(2));
                    sb.append(" - ");
                    sb.append(this.getResultString(labResult));
                    sb.append(this.getUnitAndReferenceString(labResult));
                    sb.append("\n").append(this.getPathologicString(labResult));
                    sb.append(this.getCommentString(labResult));
                    continue;
                }
                sb.append(",\n");
                sb.append(time.toString(2));
                sb.append(" - ");
                sb.append(this.getResultString(labResult));
                sb.append(this.getUnitAndReferenceString(labResult));
                sb.append("\n").append(this.getPathologicString(labResult));
                sb.append(this.getCommentString(labResult));
            }
            return sb.toString();
        }
        return null;
    }

    public Color getForeground(Object element) {
        List<LabResult> results;
        TimeTool date;
        if (element instanceof LaborItemResults && (date = (TimeTool)this.column.getColumn().getData("labresult.date")) != null && (results = ((LaborItemResults)element).getResult(date.toString(9))) != null) {
            boolean pathologic = false;
            for (LabResult labResult : results) {
                if (!labResult.isFlag(1)) continue;
                pathologic = true;
                break;
            }
            if (pathologic) {
                return Display.getCurrent().getSystemColor(3);
            }
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public Color getBackground(Object element) {
        List<LabResult> results;
        TimeTool date;
        if (element instanceof LaborItemResults && (date = (TimeTool)this.column.getColumn().getData("labresult.date")) != null && (results = ((LaborItemResults)element).getResult(date.toString(9))) != null) {
            boolean pathologic = false;
            boolean indetermined = false;
            for (LabResult labResult : results) {
                if (labResult.isFlag(1)) {
                    pathologic = true;
                    break;
                }
                indetermined = labResult.isPathologicFlagIndetermined(null);
            }
            if (!pathologic && indetermined) {
                return Display.getCurrent().getSystemColor(7);
            }
        }
        return null;
    }
}

