/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls.util;

import ca.uhn.hl7v2.model.Message;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.model.IValueType;
import ch.elexis.hl7.model.LabResultData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.util.HL7Helper;
import ch.elexis.hl7.v2x.labitem.HL7ImportLabItemReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7AutoGroupImporter {
    private static final Logger logger = LoggerFactory.getLogger(HL7AutoGroupImporter.class);
    private static final Map<String, Pattern> PROFILE_REGEX_MAP = Map.of("Analytica", Pattern.compile("^\\d{2}TEST(\\d{2})(.+)$"));
    private static ILaboratory myLab;
    private String profile;
    private IProgressMonitor monitor;

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public int importDirectory(String dirPath) throws IOException {
        File[] files;
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            logger.error("Kein Verzeichnis: " + dirPath);
        }
        if ((files = dir.listFiles((f, name) -> name.toLowerCase().endsWith(".hl7") && !name.startsWith("._"))) == null || files.length == 0) {
            logger.info("Keine .hl7-Dateien gefunden in {}", (Object)dirPath);
            return 0;
        }
        if (this.monitor != null) {
            this.monitor.beginTask("Importiere HL7-Dateien...", files.length);
        }
        int count = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.monitor != null && this.monitor.isCanceled()) break;
            if (this.monitor != null) {
                this.monitor.subTask("Verarbeite Datei: " + file.getName());
            }
            this.importFile(file.getAbsolutePath());
            if (this.monitor != null) {
                this.monitor.worked(1);
            }
            ++count;
            ++n2;
        }
        if (this.monitor != null) {
            this.monitor.done();
        }
        return count;
    }

    public void importFile(String filePath) throws IOException {
        this.profile = ConfigServiceHolder.getUser((String)"CFG_HL7_IMPORT_PROFILE", (String)"Analytica");
        File originalFile = new File(filePath);
        if (!originalFile.canRead()) {
            logger.error("File not readable: " + filePath);
            return;
        }
        File fixedFile = this.fixHL7File(originalFile);
        myLab = LabImportUtilHolder.get().getOrCreateLabor(this.profile);
        IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = VirtualFilesystemServiceHolder.get().of(fixedFile);
        ArrayList<HL7ImportLabItemReader> readerList = new ArrayList<HL7ImportLabItemReader>();
        try {
            byte[] fileBytes = fileHandle.readAllBytes();
            String fileContent = new String(fileBytes, HL7Helper.getEncoding((String)new String(fileBytes)));
            try {
                Message message = HL7Helper.parseMessage((String)fileContent);
                readerList.add(new HL7ImportLabItemReader(message));
            }
            catch (Exception exception) {
                logger.warn("Error when parsing HL7 message:\\n{}", (Object)fileContent, (Object)exception);
            }
        }
        catch (Exception e) {
            logger.error("Error parsing the HL7 file", (Throwable)e);
        }
        if (readerList.isEmpty()) {
            logger.info("No HL7 messages found in {}", (Object)filePath);
            return;
        }
        String filename = originalFile.getName();
        GroupAndPriority groupInfo = this.extractGroupAndPriorityFromFilename(filename);
        for (HL7Reader hL7Reader : readerList) {
            this.processReader(hL7Reader, groupInfo);
        }
    }

    private File fixHL7File(File originalFile) throws IOException {
        List<String> lines = Files.readAllLines(originalFile.toPath(), StandardCharsets.ISO_8859_1);
        ArrayList<String> fixedLines = new ArrayList<String>();
        for (String line : lines) {
            CharSequence[] parts;
            if (line.startsWith("OBX|") && (parts = line.split("\\|", -1)).length > 2 && (parts[2] == null || parts[2].isBlank())) {
                parts[2] = "TX";
                line = String.join((CharSequence)"|", parts);
            }
            fixedLines.add(line);
        }
        File fixedFile = File.createTempFile("hl7fixed_", ".hl7");
        Files.write(fixedFile.toPath(), fixedLines, StandardCharsets.ISO_8859_1, new OpenOption[0]);
        fixedFile.deleteOnExit();
        return fixedFile;
    }

    private void processReader(HL7Reader reader, GroupAndPriority groupInfo) {
        try {
            ObservationMessage obsMsg = reader.readObservation(null, true);
            if (obsMsg == null) {
                logger.warn("No ObservationMessage in message");
                return;
            }
            List observations = obsMsg.getObservations();
            if (observations == null || observations.isEmpty()) {
                logger.info("No observations available");
                return;
            }
            int priorityCounter = 1;
            for (IValueType iValueType : observations) {
                if (!(iValueType instanceof LabResultData)) continue;
                LabResultData lab = (LabResultData)iValueType;
                this.processLabResult(lab, groupInfo, priorityCounter++);
            }
        }
        catch (Exception e) {
            logger.error("Error parsing the message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void processLabResult(LabResultData lab, GroupAndPriority groupInfo, int priorityCounter) {
        try {
            boolean sameGroup;
            String group = this.safeGroupName(groupInfo.priority, groupInfo.groupName);
            String prio = String.valueOf(priorityCounter);
            ILabItem existing = LabImportUtilHolder.get().getLabItem(lab.getCode(), myLab);
            if (this.monitor != null) {
                this.monitor.subTask(lab.getCode() + " \u2013 " + lab.getName());
            }
            boolean bl = sameGroup = existing != null && existing.getGroup() != null && existing.getGroup().contains(groupInfo.groupName);
            if (existing == null || !sameGroup) {
                LabImportUtilHolder.get().createLabItem(lab.getCode(), lab.getName(), myLab, lab.getRange(), lab.getRange(), lab.getUnit(), lab.isNumeric() ? LabItemTyp.NUMERIC : LabItemTyp.TEXT, group, prio);
            }
        }
        catch (Exception ex) {
            logger.error("Error when creating LabItem [{}]: {}", new Object[]{lab.getCode(), ex.getMessage(), ex});
        }
    }

    private GroupAndPriority extractGroupAndPriorityFromFilename(String filename) {
        Pattern pattern;
        if (filename.endsWith(".hl7")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        if ((pattern = PROFILE_REGEX_MAP.get(this.profile)) == null) {
            logger.warn("Kein Regex-Muster f\u00fcr Profil '{}'", (Object)this.profile);
            return new GroupAndPriority("Unbekannt", "99");
        }
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find()) {
            return new GroupAndPriority(matcher.group(2), matcher.group(1));
        }
        logger.info("Keine Gruppe/Priorit\u00e4t extrahiert aus Dateiname: {}", (Object)filename);
        return new GroupAndPriority("Unbekannt", "99");
    }

    private String safeGroupName(String priority, String groupName) {
        String group = priority + " " + groupName;
        int maxLength = 25;
        if (group.length() > 25) {
            logger.info("Gruppenname gek\u00fcrzt auf {} Zeichen: {}", (Object)25, (Object)group);
            return group.substring(0, 25);
        }
        return group;
    }

    private static class GroupAndPriority {
        final String groupName;
        final String priority;

        GroupAndPriority(String groupName, String priority) {
            this.groupName = groupName;
            this.priority = priority;
        }
    }
}

