/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.model.ILabItem;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.laboratory.controls.Messages;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabMapping;
import ch.elexis.data.Labor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class LaborMappingComposite
extends Composite {
    protected TableViewer viewer;
    protected ILabItem labItem;
    protected List<LabMapping> content = Collections.emptyList();
    protected List<TransientLabMapping> transientContent = new ArrayList<TransientLabMapping>();

    public LaborMappingComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    public void setLabItem(ILabItem labItem) {
        this.labItem = labItem;
        this.refreshContent();
    }

    public void persistTransientLabMappings(ILabItem labItem) {
        for (TransientLabMapping transientMapping : this.transientContent) {
            transientMapping.persist(labItem);
        }
    }

    private void refreshContent() {
        if (this.labItem != null) {
            this.content = LabMapping.getByLabItemId((String)this.labItem.getId());
            this.viewer.setInput(this.content);
        } else {
            this.content = Collections.emptyList();
            this.viewer.setInput(this.transientContent);
        }
    }

    protected void createContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label title = new Label((Composite)this, 0);
        title.setText(Messages.LaborMappingComposite_labelMappings);
        title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBarManager toolbar = new ToolBarManager();
        toolbar.add((IAction)new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                KontaktSelektor selektor = new KontaktSelektor(LaborMappingComposite.this.getShell(), Labor.class, Messages.Core_Laboratory_Selection, Messages.Core_Select_Laboratory, Kontakt.DEFAULT_SORT);
                if (selektor.open() == 0) {
                    Labor labor = (Labor)selektor.getSelection();
                    if (LaborMappingComposite.this.labItem != null) {
                        LabMapping mapping = new LabMapping(labor.getId(), LaborMappingComposite.this.labItem.getCode(), LaborMappingComposite.this.labItem.getId(), false);
                        LaborMappingComposite.this.refreshContent();
                    } else {
                        TransientLabMapping mapping = new TransientLabMapping();
                        mapping.setOriginId(labor.getId());
                        mapping.setItemName("???");
                        LaborMappingComposite.this.transientContent.add(mapping);
                        LaborMappingComposite.this.refreshContent();
                    }
                }
            }
        });
        toolbar.add((IAction)new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)LaborMappingComposite.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.getFirstElement() instanceof LabMapping) {
                        LabMapping mapping = (LabMapping)selection.getFirstElement();
                        mapping.delete();
                        LaborMappingComposite.this.refreshContent();
                    } else if (selection.getFirstElement() instanceof TransientLabMapping) {
                        LaborMappingComposite.this.transientContent.remove(selection.getFirstElement());
                        LaborMappingComposite.this.refreshContent();
                    }
                }
            }
        });
        ToolBar toolBar = toolbar.createControl((Composite)this);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        toolbar.update(true);
        this.viewer = new TableViewer((Composite)this, 67584);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(100);
        column.getColumn().setText(Messages.Core_Laboratory);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LabMapping) {
                    return ((LabMapping)element).getOrigin().getLabel(true);
                }
                if (element instanceof TransientLabMapping) {
                    return ((TransientLabMapping)element).getOrigin().getLabel(true);
                }
                return "";
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(100);
        column.getColumn().setText(Messages.Core_Short_Label);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LabMapping) {
                    return ((LabMapping)element).getItemName();
                }
                if (element instanceof TransientLabMapping) {
                    return ((TransientLabMapping)element).getItemName();
                }
                return "";
            }
        });
        column.setEditingSupport((EditingSupport)new ItemNameEditingSupport(this.viewer));
    }

    protected class ItemNameEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;

        public ItemNameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof LabMapping) {
                return ((LabMapping)element).getItemName();
            }
            if (element instanceof TransientLabMapping) {
                return ((TransientLabMapping)element).getItemName();
            }
            return "";
        }

        protected void setValue(Object element, Object userInputValue) {
            if (element instanceof LabMapping) {
                ((LabMapping)element).setItemName(String.valueOf(userInputValue));
            } else if (element instanceof TransientLabMapping) {
                ((TransientLabMapping)element).setItemName(String.valueOf(userInputValue));
            }
            this.viewer.update(element, null);
        }
    }

    public class TransientLabMapping {
        private String originId;
        private String itemName;
        private String labItemId;
        private boolean charge;

        public void persist(ILabItem labItem) {
            new LabMapping(this.originId, this.itemName, labItem.getId(), this.charge);
        }

        public Kontakt getOrigin() {
            return Kontakt.load((String)this.originId);
        }

        public void setOriginId(String originId) {
            this.originId = originId;
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getLabItemId() {
            return this.labItemId;
        }

        public void setLabItemId(String labItemId) {
            this.labItemId = labItemId;
        }

        public boolean isCharge() {
            return this.charge;
        }

        public void setCharge(boolean charge) {
            this.charge = charge;
        }
    }
}

