/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.matchers;

import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.matchers.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Verifier {
    public static Kontakt verify(Kontakt k, String t, String m) {
        if (SWTHelper.askYesNo((String)t, (String)m)) {
            return k;
        }
        KontaktSelektor ksl = new KontaktSelektor(Hub.getActiveShell(), k.getClass(), t, Messages.Verifier_PleaseSelectCorrectContact, Kontakt.DEFAULT_SORT);
        if (ksl.open() == 0) {
            return (Kontakt)ksl.getSelection();
        }
        return null;
    }

    public static Kontakt resolveAmbiguity(List<Kontakt> list, String t, String m) {
        Resolver resolver = new Resolver(Hub.getActiveShell(), list);
        resolver.setTitle(t);
        resolver.setMessage(m);
        if (resolver.open() == 0) {
            return resolver.result;
        }
        return null;
    }

    static class Resolver
    extends TitleAreaDialog {
        List<Kontakt> list;
        Kontakt result;
        Table table;

        public Resolver(Shell shell, List<Kontakt> kont) {
            super(shell);
            this.list = kont;
        }

        protected Control createDialogArea(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            this.table = new Table(parent, 0);
            TableColumn c1 = new TableColumn(this.table, 0);
            c1.setText(Messages.Core_Name);
            c1.setWidth(200);
            TableColumn c2 = new TableColumn(this.table, 0);
            c2.setText(Messages.Core_Address);
            c2.setWidth(200);
            for (Kontakt k : this.list) {
                TableItem it = new TableItem(this.table, 0);
                it.setText(0, k.getLabel(true));
                it.setText(1, k.get("Strasse") + " " + k.get("Ort"));
            }
            return this.table;
        }

        public void create() {
            super.create();
        }

        protected void okPressed() {
            int ix = this.table.getSelectionIndex();
            this.result = ix != -1 ? this.list.get(ix) : null;
            super.okPressed();
        }
    }
}

