/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.data.Anschrift;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.Query;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediportInsurerImporter {
    private static Logger log = LoggerFactory.getLogger(MediportInsurerImporter.class);
    private static final String SEPARATOR = ";";
    private static final String MEDIPORT_CONNECTED = "an MediPort angeschlossen";
    private static final int IDX_ORGANISATION = 0;
    private static final int IDX_DEPARTMENT = 1;
    private static final int IDX_ADDR1 = 2;
    private static final int IDX_ADDR2 = 3;
    private static final int IDX_ZIP = 4;
    private static final int IDX_CITY = 5;
    private static final int IDX_PHONE = 6;
    private static final int IDX_WEBSITE = 7;
    private static final int IDX_EMAIL = 8;
    private static final int IDX_INSURANCE_EAN = 9;
    private static final int IDX_RECEPIENT_EAN = 10;
    private static final int IDX_XML_INSURANCE_NAME = 11;
    private static final int IDX_LAW_CODE = 12;
    private static final int IDX_MEDIPORT_SUPPORT = 15;

    public static List<Organisation> importCSVFromStream(InputStream csvInStream) {
        ArrayList<Organisation> insurerList = new ArrayList<Organisation>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(csvInStream));
            String line = "";
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                if (++lineNo == 1) continue;
                String[] parts = line.split(SEPARATOR, -1);
                String org = parts[0];
                String dept = parts[1];
                Object street = parts[2];
                String postbox = parts[3];
                if (postbox != null && !postbox.isEmpty()) {
                    street = (String)street + ", " + postbox;
                }
                String zip = parts[4];
                String city = parts[5];
                String phone = parts[6];
                String website = parts[7];
                String email = parts[8];
                String insuranceEAN = parts[9];
                String recepientEAN = parts[10];
                String xmlInsuranceName = parts[11];
                String lawCode = parts[12];
                String mediport = parts[15];
                Query contactQuery = new Query(Kontakt.class);
                contactQuery.add("Bezeichnung1", "=", org);
                contactQuery.add("Bezeichnung2", "=", dept);
                contactQuery.add("Strasse", "=", (String)street);
                contactQuery.add("Ort", "=", city);
                List contactList = contactQuery.execute();
                if (contactList != null && !contactList.isEmpty()) {
                    log.warn("Kontakt [" + org + " " + dept + ", " + (String)street + ", " + city + "] existiert bereits. Wird nicht imporiert.");
                    continue;
                }
                Organisation insurer = new Organisation(org, dept);
                if (!insurer.set(new String[]{"Strasse", "Plz", "Ort", "Telefon1", "E-Mail", "Website", "Versicherungsart", "XML Versicherer Name"}, new String[]{street, zip, city, phone, email, website, lawCode, xmlInsuranceName})) {
                    log.error("Kontaktdaten konnten nicht gespeichert werden.");
                }
                insurer.setAnschrift(new Anschrift((Kontakt)insurer));
                insurer.getXid();
                if (insuranceEAN != null && insuranceEAN.length() == 13) {
                    insurer.setInsurerEAN(insuranceEAN);
                }
                if (recepientEAN != null && recepientEAN.length() == 13) {
                    insurer.setRecepientEAN(recepientEAN);
                }
                insurer.setSupportsMediport(MEDIPORT_CONNECTED.equalsIgnoreCase(mediport));
                insurerList.add(insurer);
            }
            reader.close();
        }
        catch (Exception e) {
            return insurerList;
        }
        return insurerList;
    }
}

