/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenartikel;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import java.util.HashMap;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class EigenartikelTreeContentProvider
implements ITreeContentProvider,
ViewerConfigurer.ICommonViewerContentProvider {
    public static String FILTER_KEY = "Name";
    private CommonViewer commonViewer;
    private String filter = null;
    private boolean showProducts;

    public EigenartikelTreeContentProvider(CommonViewer cv) {
        this.commonViewer = cv;
    }

    public void reorder(String field) {
    }

    public void selected() {
    }

    public void init() {
    }

    public void startListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public void stopListening() {
        this.commonViewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
    }

    public Object[] getElements(Object inputElement) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IArticle.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__TYP, IQuery.COMPARATOR.EQUALS, (Object)ArticleTyp.EIGENARTIKEL);
        if (this.filter != null) {
            query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__NAME, IQuery.COMPARATOR.LIKE, (Object)("%" + this.filter + "%"), true);
        }
        if (!this.showProducts) {
            query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__PRODUCT, IQuery.COMPARATOR.NOT_EQUALS, null);
        } else {
            query.and((EStructuralFeature)ModelPackage.Literals.IARTICLE__PRODUCT, IQuery.COMPARATOR.EQUALS, null);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IARTICLE__NAME, IQuery.ORDER.ASC);
        return query.execute().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        IArticle ea;
        if (!this.showProducts) {
            return null;
        }
        if (parentElement != null && parentElement instanceof IArticle && (ea = (IArticle)parentElement).isProduct()) {
            return ea.getPackages().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (!this.showProducts) {
            return false;
        }
        IArticle ea = (IArticle)element;
        return ea.isProduct() && !ea.getPackages().isEmpty();
    }

    public void changed(HashMap<String, String> values) {
        String filterValue = values.get(FILTER_KEY).toLowerCase();
        this.filter = filterValue != null && filterValue.length() > 1 ? filterValue : null;
        this.commonViewer.notify(CommonViewer.Message.update);
    }

    public void setShowProducts(boolean checked) {
        this.showProducts = checked;
        this.commonViewer.notify(CommonViewer.Message.update);
    }
}

