/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.composites;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.ui.documents.composites.DocumentsTableContentProvider;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.documents.views.DocumentsViewerComparator;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.rgw.tools.TimeTool;
import java.util.Optional;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class DocumentsSelectionComposite
extends Composite {
    private TableViewer viewer;
    private DocumentsTableContentProvider contentProvider;
    private DocumentsViewerComparator documentsViewerComparator;
    private String filterText;

    public DocumentsSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer((Composite)this, 66304);
        this.contentProvider = new DocumentsTableContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 200;
        this.viewer.getTable().setLayoutData((Object)gd);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText("");
        column.setWidth(20);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public String getToolTipText(Object element) {
                IDocument doc;
                if (element instanceof IDocument && !(doc = (IDocument)element).getStatus().isEmpty()) {
                    return doc.getStatus().stream().map(s -> s.getName()).reduce((u, t) -> u + "," + t).get();
                }
                return super.getToolTipText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    Optional<DocumentStatus> sent = doc.getStatus().stream().filter(s -> s == DocumentStatus.SENT).findFirst();
                    if (sent.isPresent()) {
                        return Images.IMG_OUTBOX.getImage();
                    }
                    return Images.IMG_INBOX.getImage();
                }
                return super.getImage(element);
            }
        });
        viewerColumn = new TableViewerColumn(this.viewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.Core_Category);
        column.setWidth(150);
        column.setResizable(true);
        column.setMoveable(false);
        column.addSelectionListener(this.getSelectionAdapter(column, 2));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return doc.getCategory().getName();
                }
                if (element instanceof ICategory) {
                    ICategory cat = (ICategory)element;
                    return cat.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof ICategory) {
                    return Images.IMG_FOLDER.getImage();
                }
                return super.getImage(element);
            }
        });
        viewerColumn = new TableViewerColumn(this.viewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.Core_Date);
        column.setWidth(100);
        column.setResizable(true);
        column.setMoveable(false);
        column.addSelectionListener(this.getSelectionAdapter(column, 3));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return new TimeTool(doc.getLastchanged()).toString(4);
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return new TimeTool(doc.getLastchanged()).toString(1);
                }
                return super.getToolTipText(element);
            }
        });
        viewerColumn = new TableViewerColumn(this.viewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.Core_Title);
        column.setWidth(250);
        column.setResizable(true);
        column.setMoveable(false);
        column.addSelectionListener(this.getSelectionAdapter(column, 5));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return doc.getTitle();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    Optional opt = DocumentStoreServiceHolder.getService().getPersistenceObject(doc);
                    if (opt.isPresent() && ((ILocalDocumentService)LocalDocumentServiceHolder.getService().get()).contains(opt.get())) {
                        return Images.IMG_EDIT.getImage();
                    }
                }
                return super.getImage(element);
            }
        });
        viewerColumn = new TableViewerColumn(this.viewer, 0);
        column = viewerColumn.getColumn();
        column.setText(Messages.Core_Keywords);
        column.setWidth(250);
        column.setResizable(true);
        column.setMoveable(false);
        column.addSelectionListener(this.getSelectionAdapter(column, 5));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    return doc.getKeywords();
                }
                return "";
            }
        });
        this.documentsViewerComparator = new DocumentsViewerComparator();
        this.documentsViewerComparator.setBFlat(true);
        this.viewer.setComparator((ViewerComparator)this.documentsViewerComparator);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDocument) {
                    IDocument doc = (IDocument)element;
                    if (DocumentsSelectionComposite.this.filterText == null || DocumentsSelectionComposite.this.filterText.isEmpty()) {
                        return true;
                    }
                    String lowerFilterText = DocumentsSelectionComposite.this.filterText.toLowerCase();
                    return doc.getTitle().toLowerCase().contains(lowerFilterText) || doc.getKeywords().toLowerCase().contains(lowerFilterText) || doc.getCategory().getName().toLowerCase().contains(lowerFilterText) || new TimeTool(doc.getLastchanged()).toString(4).contains(lowerFilterText);
                }
                return true;
            }
        });
    }

    public void setFilter(String filterText) {
        this.filterText = filterText;
        this.viewer.refresh();
    }

    private SelectionListener getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentsSelectionComposite.this.documentsViewerComparator.setColumn(index);
                DocumentsSelectionComposite.this.viewer.getTable().setSortDirection(DocumentsSelectionComposite.this.documentsViewerComparator.getDirection());
                DocumentsSelectionComposite.this.viewer.getTable().setSortColumn(column);
                DocumentsSelectionComposite.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public IStructuredSelection getSelection() {
        return this.viewer.getStructuredSelection();
    }

    public void setPatient(IPatient patient) {
        this.viewer.setInput((Object)patient);
    }
}

