/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.syntactic;

import ch.elexis.core.ui.dbcheck.CheckExec;
import ch.elexis.core.ui.dbcheck.model.DBModel;
import ch.elexis.core.ui.dbcheck.syntactic.SyntacticCheck;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkSyntaxException;
import ch.rgw.tools.Log;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class SyntacticCheckMySQL
extends SyntacticCheck {
    private static Log logger = Log.get((String)SyntacticCheckMySQL.class.getName());

    public SyntacticCheckMySQL() {
        this.oklog = new StringBuilder();
        this.errlog = new StringBuilder();
        this.fixScript = new StringBuilder();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String checkCoreTables(JdbcLink j, IProgressMonitor monitor) {
        version = CheckExec.getDBVersion();
        tables = DBModel.getTableModel(version);
        try {
            stmColl = j.getStatement();
            l = 0;
            while (l < tables.length) {
                block20: {
                    status = "\u00dcberpr\u00fcfe textvergleich (collation) auf Tabelle " + tables[l];
                    rsColl = null;
                    this.oklog.append(tables[l] + ": Pr\u00fcfe textvergleich (collation) ...");
                    try {
                        rsColl = stmColl.query("SELECT table_collation FROM information_schema.tables WHERE UPPER(table_name) = \"" + tables[l].toUpperCase() + "\"");
                    }
                    catch (JdbcLinkSyntaxException je) {
                        this.errlog.append(tables[l] + ": SynErr: Tabelle nicht gefunden!\n");
                        break block20;
                    }
                    if (!rsColl.next()) {
                        this.errlog.append(tables[l] + " Error in selecting table_collation\n");
                    } else {
                        collation = rsColl.getString(1);
                        if (!collation.equalsIgnoreCase("utf8_general_ci")) {
                            this.oklog.append(" " + collation + " inkorrekt, erwarte utf8_general_ci\n");
                            this.errlog.append(tables[l] + ": Collation " + collation + " inkorrekt, erwarte utf8_general_ci\n");
                            this.fixScript.append("ALTER TABLE " + tables[l] + " CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci;\n");
                        } else {
                            this.oklog.append(" OK\n");
                        }
                    }
                }
                ++l;
            }
            j.releaseStatement(stmColl);
            i = 0;
            while (i < tables.length) {
                status = "\u00dcberpr\u00fcfe Tabelle " + tables[i];
                if (monitor != null) {
                    monitor.subTask(status);
                }
                this.oklog.append(status + ":\n");
                tableDetail = DBModel.getTableDescription(tables[i]);
                fields = tableDetail.getFields(version);
                fieldType = tableDetail.getFieldTypes(version);
                k = 0;
                while (k < fields.length) {
                    block21: {
                        ok = false;
                        this.oklog.append(tables[i] + ": Erwarte " + fields[k] + " " + fieldType[k] + "...");
                        stm = j.getStatement();
                        rs = null;
                        try {
                            rs = stm.query("DESCRIBE " + tables[i].toLowerCase() + " " + fields[k]);
                            ** GOTO lbl75
                        }
                        catch (JdbcLinkSyntaxException je) {
                            try {
                                rs = stm.query("DESCRIBE " + tables[i] + " " + fields[k]);
                                if (true) ** GOTO lbl75
                            }
                            catch (JdbcLinkSyntaxException je2) {
                                break block21;
                            }
                        }
                        do {
                            ok = true;
                            if (rs.getString(1).equalsIgnoreCase(fields[k]) && SyntacticCheckMySQL.isCompatible(rs.getString(2), fieldType[k])) {
                                this.oklog.append(" OK\n");
                                continue;
                            }
                            this.oklog.append(" erhalte " + rs.getString(1) + " " + rs.getString(2) + "\n");
                            this.errlog.append(tables[i] + ": SynErr: FeldTyp " + rs.getString(1) + " " + rs.getString(2) + " inkorrekt, erwarte " + fields[k] + " " + fieldType[k] + "\n");
                            this.fixScript.append("ALTER TABLE " + tables[i] + " MODIFY " + fields[k] + " " + fieldType[k] + ";\n");
lbl75:
                            // 4 sources

                        } while (rs.next());
                        if (!ok) {
                            this.oklog.append(" not found\n");
                            this.errlog.append(tables[i] + ": SynErr: Feld " + fields[k] + " " + fieldType[k] + " nicht gefunden!\n");
                            this.fixScript.append("ALTER TABLE " + tables[i] + " ADD " + fields[k] + " " + fieldType[k]);
                        }
                        j.releaseStatement(stm);
                        rs.close();
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (SQLException e) {
            status = new Status(4, "ch.elexis.core.ui.dbcheck", e.getLocalizedMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 4);
        }
        fixScriptOut = this.fixScript.toString();
        if (fixScriptOut.length() > 0) {
            SyntacticCheckMySQL.logger.log("\n================ Database Check Tool ====================\n-- MySQL fix script -- apply on your database! ----------\n-- K E I N E GARANTIE, CODE VOR ANWENDUNG PR\u00dcFEN --------\n================== START OF DATA ========================\n" + fixScriptOut + "==================== END OF DATA ========================\n", 2);
        }
        return this.oklog.toString();
    }
}

