/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.semantic;

import ch.elexis.core.ui.dbcheck.CheckExec;
import ch.elexis.core.ui.dbcheck.model.DBModel;
import ch.elexis.core.ui.dbcheck.model.TableDescriptor;
import ch.elexis.core.ui.dbcheck.semantic.SemanticCheck;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.JdbcLinkSyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;

public class SemanticCheckMySQL
extends SemanticCheck {
    public SemanticCheckMySQL() {
        this.oklog = new StringBuilder();
        this.errlog = new StringBuilder();
    }

    @Override
    public String checkSemanticStateCoreTables(JdbcLink j, IProgressMonitor monitor) {
        String version = CheckExec.getDBVersion();
        String[] tables = DBModel.getTableModel(version);
        try {
            int i = 0;
            while (i < tables.length) {
                String status = "\u00dcberpr\u00fcfe Tabelle " + tables[i];
                monitor.subTask(status);
                this.oklog.append(status + ":\n");
                TableDescriptor tableDetail = DBModel.getTableDescription(tables[i]);
                String[] invalidStates = tableDetail.getInvalidStates(version);
                if (invalidStates != null && invalidStates.length > 0) {
                    int k = 0;
                    while (k < invalidStates.length) {
                        String query = invalidStates[k];
                        JdbcLink.Stm stm = j.getStatement();
                        ResultSet rs = null;
                        try {
                            rs = stm.query("SELECT * FROM " + tables[i].toLowerCase() + " WHERE " + query.toLowerCase());
                        }
                        catch (JdbcLinkSyntaxException je) {
                            try {
                                rs = stm.query("SELECT * FROM " + tables[i] + " WHERE " + query.toLowerCase());
                            }
                            catch (JdbcLinkSyntaxException je2) {
                                this.errlog.append(tables[i] + ": Semantischer Fehler bei Query <<" + query + ">> auf ID " + String.valueOf(rs != null ? rs.getString(1) : rs) + "\n");
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            e.getMessage();
        }
        return this.oklog.toString();
    }
}

