/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.rgw.tools.VersionedResource;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class FixPatientEncounters
extends ExternalMaintenance {
    private String patientNumber;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Display.getDefault().syncExec(() -> {
            InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), "Patient number", "Insert number of patient to fix encounters", "", null, 2628);
            if (inputDialog.open() == 0) {
                this.patientNumber = inputDialog.getValue();
            }
        });
        IPatient patient = (IPatient)CoreModelServiceHolder.get().getQuery(IPatient.class).and("code", IQuery.COMPARATOR.EQUALS, (Object)this.patientNumber).executeSingleResult().orElseThrow(() -> new IllegalStateException("No patient with number [" + this.patientNumber + "]"));
        int checked = 0;
        int fixed = 0;
        List allEncounters = EncounterServiceHolder.get().getAllEncountersForPatient(patient);
        pm.beginTask("Fixing encounters", allEncounters.size());
        for (IEncounter iEncounter : allEncounters) {
            VersionedResource vr = iEncounter.getVersionedEntry();
            String s = vr.getHead();
            String noControlChar = this.filterNonPrintable(s);
            if (noControlChar.toCharArray().length != s.toCharArray().length) {
                vr.update(noControlChar, "Fix invalid char");
                iEncounter.setVersionedEntry(vr);
                CoreModelServiceHolder.get().save((Identifiable)iEncounter);
                ++fixed;
            }
            ++checked;
        }
        pm.done();
        return fixed + " invalid encounters fixed of " + checked + " overall";
    }

    private String filterNonPrintable(String input) {
        return input.replaceAll("[\\p{Cntrl}&&[^\r\n\t]]", "");
    }

    @Override
    public String getMaintenanceDescription() {
        return "Fix invalid encounters of a patient";
    }
}

