/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixEmptyDiagnoseKonsultation
extends ExternalMaintenance {
    private HashMap<Mandant, Integer> missingMap;
    private HashMap<Mandant, String> mandantDiagnoseMap;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.missingMap = new HashMap();
        this.mandantDiagnoseMap = new HashMap();
        StringBuilder output = new StringBuilder();
        pm.beginTask("Fixing consultations with no diagnose", 3);
        pm.subTask("Find all consultations ...");
        Query qbe = new Query(Konsultation.class);
        qbe.add("RechnungsID", "", null);
        List kons = qbe.execute();
        pm.worked(1);
        pm.subTask("Find consultations without diagnose ...");
        for (Konsultation k : kons) {
            Fall fall = k.getFall();
            if (fall == null || !fall.exists() || !fall.isOpen() || !k.getDiagnosen().isEmpty()) continue;
            Mandant mandant = k.getMandant();
            String diagnoseId = CoreHub.getUserSetting((Kontakt)mandant).get("fall/std_diagnose", "");
            Object diagnoseLabel = null;
            if (diagnoseId != null && !diagnoseId.isEmpty()) {
                Optional diagnose = StoreToStringServiceHolder.get().loadFromString(diagnoseId);
                if (diagnose.isPresent()) {
                    IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
                    encounter.addDiagnosis((IDiagnosis)diagnose.get());
                    CoreModelServiceHolder.get().save((Identifiable)encounter);
                    diagnoseLabel = ((Identifiable)diagnose.get()).getLabel();
                } else {
                    diagnoseLabel = diagnoseId + " existiert nicht";
                }
            }
            int found = 1;
            if (this.missingMap.containsKey(mandant)) {
                found = this.missingMap.get(mandant) + 1;
            }
            this.missingMap.put(mandant, found);
            if (this.mandantDiagnoseMap.containsKey(mandant)) continue;
            this.mandantDiagnoseMap.put(mandant, (String)diagnoseLabel);
        }
        pm.worked(1);
        pm.subTask("Show results ...");
        for (Mandant mandant : this.mandantDiagnoseMap.keySet()) {
            String diagnose = this.mandantDiagnoseMap.get(mandant);
            int result = this.missingMap.get(mandant);
            if (diagnose == null) {
                output.append(mandant.getVorname() + " " + mandant.getName() + " (" + mandant.getLabel() + "): " + result + " Konsultationen ohne Diagnose (keine Standarddiagnose definiert)\n");
                continue;
            }
            output.append(mandant.getVorname() + " " + mandant.getName() + " (" + mandant.getLabel() + "): " + result + " Konsultationen mit Standarddiagnose (" + diagnose + ") vervollst\u00e4ndigt\n");
        }
        pm.worked(1);
        pm.done();
        return output.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Standarddiagnose f\u00fcr offene Konsultationen ohne Diagnose eintragen";
    }
}

