/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.syntactic;

public class DataType {
    String dataType;
    int dataTypeSize = -1;

    public DataType(String dt) {
        int i = dt.indexOf("(");
        int j = dt.indexOf(")");
        if (i > 0 && j > 0) {
            this.dataType = dt.substring(0, i);
            String dataTypeSizeStr = dt.substring(i + 1, j);
            this.dataTypeSize = Integer.parseInt(dataTypeSizeStr);
        }
    }

    public String toString() {
        return this.dataType + " of size " + this.dataTypeSize;
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getDataTypeSize() {
        return this.dataTypeSize;
    }

    public boolean isCompatibleWith(DataType requested) {
        boolean dtc = this.dataTypeCompatible(requested);
        boolean sizeCompatible = false;
        if (this.dataTypeSize == -1) {
            sizeCompatible = true;
        } else if (this.dataTypeSize >= requested.getDataTypeSize()) {
            sizeCompatible = true;
        }
        return dtc && sizeCompatible;
    }

    private boolean dataTypeCompatible(DataType requested) {
        if (this.dataType.equalsIgnoreCase(requested.getDataType())) {
            return true;
        }
        if (this.comp("bpchar", "char", requested)) {
            return true;
        }
        return this.comp("varchar", "char", requested);
    }

    private boolean comp(String string, String string2, DataType requested) {
        String dtR = requested.getDataType();
        String dtF = this.dataType;
        return dtF.equalsIgnoreCase(string) && dtR.equalsIgnoreCase(string2);
    }
}

