/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.syntactic;

import ch.elexis.core.ui.dbcheck.syntactic.DataType;
import ch.rgw.tools.JdbcLink;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class SyntacticCheck {
    StringBuilder oklog;
    StringBuilder errlog;
    StringBuilder fixScript;

    public abstract String checkCoreTables(JdbcLink var1, IProgressMonitor var2);

    public String getErrorLog() {
        return this.errlog.toString();
    }

    public String getOutputLog() {
        return this.oklog.toString();
    }

    public String getFixScript() {
        return this.fixScript.toString();
    }

    protected static boolean isCompatible(String dataTypeFound, String dataTypeRequested) {
        if (dataTypeFound.equalsIgnoreCase(dataTypeRequested)) {
            return true;
        }
        DataType found = new DataType(dataTypeFound);
        DataType requested = new DataType(dataTypeRequested);
        if (found.isCompatibleWith(requested)) {
            return true;
        }
        if (dataTypeFound.equalsIgnoreCase("int8(19)") && dataTypeRequested.equalsIgnoreCase("bigint(20)")) {
            return true;
        }
        if (dataTypeFound.equalsIgnoreCase("blob") && dataTypeRequested.equalsIgnoreCase("longblob")) {
            return true;
        }
        if (dataTypeFound.equalsIgnoreCase("text") && dataTypeRequested.equalsIgnoreCase("longtext")) {
            return true;
        }
        if (dataTypeFound.equalsIgnoreCase("text(2147483647)") && dataTypeRequested.equalsIgnoreCase("longtext")) {
            return true;
        }
        return dataTypeFound.equalsIgnoreCase("bytea(2147483647)") && dataTypeRequested.equalsIgnoreCase("longblob");
    }
}

