/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.service.CodeElementServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixPrescriptionOldArticle
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        int nonExisting = 0;
        int nonEan = 0;
        int nonFound = 0;
        int fixed = 0;
        ICodeElementServiceContribution artikelstammContribution = (ICodeElementServiceContribution)CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.ARTICLE, "Artikelstamm").orElseThrow(() -> new IllegalStateException("No Artikelstamm available"));
        Query query = new Query(Prescription.class);
        List prescriptions = query.execute();
        pm.beginTask("Fixing prescriptions", prescriptions.size());
        for (Prescription prescription : prescriptions) {
            if (StringUtils.isEmpty((CharSequence)prescription.get("Artikel")) && StringUtils.isNotEmpty((CharSequence)prescription.get("ArtikelID"))) {
                Optional loadedArtikel = CoreModelServiceHolder.get().load(prescription.get("ArtikelID"), IArticle.class);
                if (loadedArtikel.isPresent()) {
                    if (StringUtils.isNotEmpty((CharSequence)((IArticle)loadedArtikel.get()).getGtin())) {
                        Optional loaded = artikelstammContribution.loadFromCode(((IArticle)loadedArtikel.get()).getGtin());
                        if (loaded.isPresent()) {
                            prescription.set("Artikel", StoreToStringServiceHolder.getStoreToString(loaded.get()));
                            ++fixed;
                        } else {
                            ++nonFound;
                        }
                    } else {
                        ++nonEan;
                    }
                } else {
                    ++nonExisting;
                }
            }
            pm.worked(1);
        }
        return "Prescriptions fixed " + fixed + ", article ean not found " + nonFound + ", article no ean " + nonEan + ", article not existing " + nonExisting;
    }

    @Override
    public String getMaintenanceDescription() {
        return "Fix prescription entries with id references, with Artikelstamm EAN lookup";
    }
}

