/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IPayment;
import ch.elexis.core.model.builder.IAccountTransactionBuilder;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixCancelledInvoices
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        int checked = 0;
        int fixed = 0;
        IQuery paymentQuery = CoreModelServiceHolder.get().getQuery(IPayment.class);
        paymentQuery.and("remark", IQuery.COMPARATOR.EQUALS, (Object)"Storno");
        Throwable throwable = null;
        Object var8_9 = null;
        try (IQueryCursor payments = paymentQuery.executeAsCursor();){
            pm.beginTask("Fixing cancelled invoice transactions", payments.size());
            while (payments.hasNext()) {
                ++checked;
                IPayment payment = (IPayment)payments.next();
                IQuery transactionQuery = CoreModelServiceHolder.get().getQuery(IAccountTransaction.class);
                transactionQuery.and("zahlung", IQuery.COMPARATOR.EQUALS, (Object)payment);
                List matchingTransactions = transactionQuery.execute();
                if (matchingTransactions.isEmpty()) {
                    new IAccountTransactionBuilder(CoreModelServiceHolder.get(), payment).buildAndSave();
                    ++fixed;
                }
                pm.worked(1);
                if (!pm.isCanceled()) continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        pm.done();
        output.append("Checked " + checked + " storno payments, and added " + fixed + " storno transactions");
        return output.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Rechnungs Storno, fehlende Buchungen zu Zahlungen erstellen";
    }
}

