/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.ui.contacts.views.util.FaceDetectionUtil;
import ch.elexis.core.ui.contacts.views.util.ImageDataFactory;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.bytedeco.javacv.VideoInputFrameGrabber;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientCameraCaptureDialog {
    private static final Logger logger = LoggerFactory.getLogger(PatientCameraCaptureDialog.class);
    private FrameGrabber grabber;
    private volatile Frame currentFrame;
    private final Java2DFrameConverter converter = new Java2DFrameConverter();
    private BufferedImage capturedImage;
    private static final String CAMERA_DEFAULT_KEY = "camera.default.index";
    private static Integer cachedCameraCount = null;
    private static String[] cachedCameraNames = null;
    private final AtomicInteger streamGeneration = new AtomicInteger(0);
    private final AtomicReference<CompletableFuture<?>> grabberFuture = new AtomicReference<Object>(null);
    private volatile Rectangle liveFaceRect = null;
    private static final int FRAME_DELAY_MS = 33;
    private static final int CAMERA_COUNT_POLL_INTERVAL_MS = 40;
    private static volatile boolean cameraCountingFlag = false;

    public byte[] openAndCaptureImage(Shell parentShell) {
        FontData[] fD;
        Shell realParent = parentShell != null ? parentShell : Display.getDefault().getActiveShell();
        Shell shell = new Shell(realParent, 34928);
        shell.setText(Messages.PatientCameraCaptureDialog_Title);
        shell.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite((Composite)shell, 0);
        top.setLayout((Layout)new GridLayout(3, false));
        top.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label camLabel = new Label(top, 0);
        camLabel.setText(Messages.PatientCameraCaptureDialog_CameraLabel);
        Combo camCombo = new Combo(top, 12);
        camCombo.setEnabled(false);
        GridData comboGD = new GridData(4, 0x1000000, true, false);
        comboGD.widthHint = 250;
        camCombo.setLayoutData((Object)comboGD);
        Button chkDefault = new Button(top, 0x200000);
        chkDefault.setText(Messages.PatientCameraCaptureDialog_UseAsDefaultCamera);
        chkDefault.setEnabled(false);
        Canvas canvas = new Canvas((Composite)shell, 0x20000800);
        GridData canvasData = new GridData(4, 4, true, true);
        canvasData.minimumWidth = 320;
        canvasData.minimumHeight = 240;
        canvas.setLayoutData((Object)canvasData);
        Image[] previewImage = new Image[1];
        canvas.addPaintListener(e -> {
            if (previewImage[0] != null) {
                Rectangle bounds = canvas.getClientArea();
                e.gc.drawImage(previewImage[0], 0, 0, imageArray[0].getBounds().width, imageArray[0].getBounds().height, 0, 0, bounds.width, bounds.height);
                if (this.liveFaceRect != null) {
                    e.gc.setLineWidth(3);
                    e.gc.setForeground(shell.getDisplay().getSystemColor(3));
                    double scaleX = (double)bounds.width / (double)imageArray[0].getBounds().width;
                    double scaleY = (double)bounds.height / (double)imageArray[0].getBounds().height;
                    int rx = (int)((double)this.liveFaceRect.x * scaleX);
                    int ry = (int)((double)this.liveFaceRect.y * scaleY);
                    int rw = (int)((double)this.liveFaceRect.width * scaleX);
                    int rh = (int)((double)this.liveFaceRect.height * scaleY);
                    e.gc.drawRectangle(rx, ry, rw, rh);
                }
            } else {
                e.gc.drawText(Messages.PatientCameraCaptureDialog_CameraStartingText, 10, 20);
            }
        });
        Composite buttonArea = new Composite((Composite)shell, 0);
        buttonArea.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        buttonArea.setLayout((Layout)new GridLayout(1, false));
        Canvas btnCapture = new Canvas(buttonArea, 0);
        btnCapture.setCursor(shell.getDisplay().getSystemCursor(21));
        GridData buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.widthHint = 220;
        buttonData.heightHint = 50;
        btnCapture.setLayoutData((Object)buttonData);
        FontData[] fontDataArray = fD = btnCapture.getFont().getFontData();
        int n = fD.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(18);
            ++n2;
        }
        Font customFont = new Font((Device)shell.getDisplay(), fD);
        btnCapture.setFont(customFont);
        btnCapture.addPaintListener(e -> {
            e.gc.setAntialias(1);
            Rectangle r = btnCapture.getClientArea();
            e.gc.setBackground(shell.getDisplay().getSystemColor(3));
            e.gc.setForeground(shell.getDisplay().getSystemColor(18));
            e.gc.fillRoundRectangle(r.x, r.y, r.width - 1, r.height - 1, r.height, r.height);
            e.gc.drawRoundRectangle(r.x, r.y, r.width - 1, r.height - 1, r.height, r.height);
            String txt = Messages.PatientCameraCaptureDialog_CaptureButtonText;
            Point ts = e.gc.textExtent(txt);
            e.gc.setForeground(shell.getDisplay().getSystemColor(1));
            e.gc.drawText(txt, (r.width - ts.x) / 2, (r.height - ts.y) / 2, true);
        });
        shell.setSize(660, 610);
        shell.setLocation(realParent.getLocation().x + 40, realParent.getLocation().y + 40);
        Display display = shell.getDisplay();
        shell.addListener(12, e -> {
            try {
                this.streamGeneration.incrementAndGet();
                this.stopGrabberQuietly();
            }
            catch (Exception ex) {
                logger.error("Cleanup error (grabber): {}", (Object)ex.getMessage(), (Object)ex);
            }
            try {
                if (previewImage[0] != null) {
                    previewImage[0].dispose();
                    imageArray[0] = null;
                }
            }
            catch (Exception ex) {
                logger.error("Cleanup error (preview): {}", (Object)ex.getMessage(), (Object)ex);
            }
            if (customFont != null && !customFont.isDisposed()) {
                customFont.dispose();
            }
        });
        Runnable startGrabber = () -> {
            if (shell.isDisposed() || camCombo.isDisposed()) {
                return;
            }
            int myGen = this.streamGeneration.incrementAndGet();
            int cameraIndex = camCombo.getSelectionIndex();
            this.stopGrabberQuietly();
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.lambda$4(cameraIndex, display, shell, myGen, canvas, previewImage));
            this.grabberFuture.set(future);
        };
        shell.open();
        Runnable afterCount = () -> this.lambda$7(shell, camCombo, chkDefault, btnCapture, display, startGrabber);
        if (cachedCameraCount != null) {
            display.asyncExec(afterCount);
        } else {
            CompletableFuture.runAsync(() -> {
                if (PatientCameraCaptureDialog.cameraCountingInProgress()) {
                    while (cachedCameraCount == null) {
                        try {
                            Thread.sleep(40L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } else {
                    PatientCameraCaptureDialog.setCameraCountingInProgress(true);
                    int count = this.getCameraCount();
                    cachedCameraCount = count;
                    PatientCameraCaptureDialog.setCameraCountingInProgress(false);
                }
            }).thenRunAsync(() -> display.asyncExec(afterCount));
        }
        btnCapture.addListener(4, e -> {
            if (e.button == 1) {
                this.captureAndClose(shell, display, camCombo, chkDefault);
            }
        });
        display.addFilter(1, e -> {
            if (e.keyCode == 13 || e.keyCode == 0x1000050 || e.keyCode == 32) {
                this.captureAndClose(shell, display, camCombo, chkDefault);
            }
        });
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.capturedImage == null) {
            return null;
        }
        Rectangle faceRect = this.liveFaceRect;
        BufferedImage cropped = null;
        if (faceRect == null || faceRect.x < 0 || faceRect.y < 0 || faceRect.x + faceRect.width > this.capturedImage.getWidth() || faceRect.y + faceRect.height > this.capturedImage.getHeight()) {
            logger.warn("No face detected during photo capture.");
            this.showError(realParent, Messages.PatientCameraCaptureDialog_NoFaceDetected);
            return null;
        }
        cropped = this.capturedImage.getSubimage(faceRect.x, faceRect.y, faceRect.width, faceRect.height);
        BufferedImage resized = PatientCameraCaptureDialog.resizeImage(cropped, 390, 390);
        try {
            Throwable throwable = null;
            Object var24_28 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)resized, MimeType.png.name(), baos);
                return baos.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            logger.error("Error saving patient photo to PNG: {}", (Object)ex.getMessage(), (Object)ex);
            this.showError(realParent, Messages.PatientCameraCaptureDialog_SaveError + ex.getMessage());
            return null;
        }
    }

    private static BufferedImage resizeImage(BufferedImage src, int width, int height) {
        BufferedImage resized = new BufferedImage(width, height, 1);
        Graphics2D g2 = resized.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(src, 0, 0, width, height, null);
        g2.dispose();
        return resized;
    }

    public static BufferedImage flipHorizontal(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage d = new BufferedImage(w, h, img.getType());
        Graphics2D g = d.createGraphics();
        g.drawImage(img, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return d;
    }

    public static Rectangle addPadding(Rectangle faceRect, BufferedImage img, double percent) {
        int paddingX = (int)((double)faceRect.width * percent);
        int paddingY = (int)((double)faceRect.height * percent);
        int x = Math.max(0, faceRect.x - paddingX);
        int y = Math.max(0, faceRect.y - paddingY);
        int width = Math.min(faceRect.width + 2 * paddingX, img.getWidth() - x);
        int height = Math.min(faceRect.height + 2 * paddingY, img.getHeight() - y);
        return new Rectangle(x, y, width, height);
    }

    private Integer loadDefaultCameraIndex() {
        String val = LocalConfigService.get((String)CAMERA_DEFAULT_KEY, null);
        try {
            return val != null ? Integer.valueOf(Integer.parseInt(val)) : null;
        }
        catch (NumberFormatException e) {
            logger.warn("Invalid default camera index in configuration: {}", (Object)val);
            return null;
        }
    }

    private int getCameraCount() {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                String[] names = VideoInputFrameGrabber.getDeviceDescriptions();
                cachedCameraNames = names;
                return names != null ? names.length : 0;
            }
            return cachedCameraNames != null ? cachedCameraNames.length : 0;
        }
        catch (Exception e) {
            logger.warn("Could not read camera device descriptions: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    public static void initCameraCacheAsync(Display display) {
        if (cachedCameraCount != null || PatientCameraCaptureDialog.cameraCountingInProgress()) {
            return;
        }
        PatientCameraCaptureDialog.setCameraCountingInProgress(true);
        CompletableFuture.runAsync(() -> {
            int count = 0;
            int maxTry = 6;
            String[] names = new String[maxTry];
            while (count < maxTry) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (OpenCVFrameGrabber g = new OpenCVFrameGrabber(count);){
                        g.start();
                        g.grab();
                        g.stop();
                        names[count] = Messages.PatientCameraCaptureDialog_DeviceName + (count + 1);
                        ++count;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    break;
                }
            }
            cachedCameraCount = count;
            cachedCameraNames = new String[count];
            System.arraycopy(names, 0, cachedCameraNames, 0, count);
            PatientCameraCaptureDialog.setCameraCountingInProgress(false);
        }).thenRunAsync(() -> {
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> logger.info("Camera cache loaded: {} devices.", (Object)cachedCameraCount));
            }
        });
    }

    private static boolean cameraCountingInProgress() {
        return cameraCountingFlag;
    }

    private static void setCameraCountingInProgress(boolean v) {
        cameraCountingFlag = v;
    }

    private void stopGrabberQuietly() {
        block9: {
            block8: {
                try {
                    try {
                        if (this.grabber == null) break block8;
                        try {
                            this.grabber.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            this.grabber.release();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception ex) {
                        logger.error("Error stopping video grabber: {}", (Object)ex.getMessage(), (Object)ex);
                        this.grabber = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.grabber = null;
                    throw throwable;
                }
            }
            this.grabber = null;
        }
        this.grabberFuture.set(null);
    }

    private void showError(Shell shell, String msg) {
        logger.error("Camera dialog error: {}", (Object)msg);
        MessageBox box = new MessageBox(shell, 33);
        box.setMessage(msg);
        box.open();
    }

    private void captureAndClose(Shell shell, Display display, Combo camCombo, Button chkDefault) {
        BufferedImage original;
        if (this.currentFrame != null && (original = this.converter.getBufferedImage(this.currentFrame)) != null) {
            BufferedImage flipped;
            this.capturedImage = flipped = PatientCameraCaptureDialog.flipHorizontal(original);
        }
        if (chkDefault != null && !chkDefault.isDisposed() && camCombo != null && !camCombo.isDisposed() && chkDefault.getSelection()) {
            LocalConfigService.set((String)CAMERA_DEFAULT_KEY, (String)String.valueOf(camCombo.getSelectionIndex()));
        }
        if (shell != null && !shell.isDisposed()) {
            shell.setVisible(false);
            display.asyncExec(() -> {
                if (!shell.isDisposed()) {
                    shell.dispose();
                }
            });
        }
    }

    private FrameGrabber createGrabber(int cameraIndex) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.contains("win")) {
                return new VideoInputFrameGrabber(cameraIndex);
            }
            return new OpenCVFrameGrabber(cameraIndex);
        }
        catch (Exception e) {
            logger.error("Error creating grabber for camera {}: {}", new Object[]{cameraIndex, e.getMessage(), e});
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$7(Shell var1_1, Combo var2_2, Button var3_3, Canvas var4_4, Display var5_5, Runnable var6_6) {
        block9: {
            if (var1_1.isDisposed() || var2_2.isDisposed()) {
                return;
            }
            v0 = cameraCount = PatientCameraCaptureDialog.cachedCameraCount != null ? PatientCameraCaptureDialog.cachedCameraCount : 0;
            if (cameraCount == 0) {
                PatientCameraCaptureDialog.logger.warn("No camera found on this system.");
                this.showError(var1_1, Messages.PatientCameraCaptureDialog_NoCameraFound);
                var2_2.setEnabled(false);
                var3_3.setEnabled(false);
                var4_4.setEnabled(false);
                return;
            }
            try {
                cameraNames = System.getProperty("os.name").toLowerCase().contains("win") != false ? VideoInputFrameGrabber.getDeviceDescriptions() : PatientCameraCaptureDialog.cachedCameraNames;
                var12_11 = cameraNames;
                var11_12 = cameraNames.length;
                var10_13 = 0;
                while (var10_13 < var11_12) {
                    name = var12_11[var10_13];
                    if (!var2_2.isDisposed()) {
                        var2_2.add(name);
                    }
                    ++var10_13;
                }
                break block9;
            }
            catch (Exception e) {
                PatientCameraCaptureDialog.logger.error("Error reading camera device descriptions: {}", (Object)e.getMessage(), (Object)e);
                i = 0;
                ** while (i < cameraCount)
            }
lbl-1000:
            // 1 sources

            {
                if (!var2_2.isDisposed()) {
                    var2_2.add(Messages.PatientCameraCaptureDialog_DeviceName + (i + 1));
                }
                ++i;
                continue;
            }
        }
        if (var2_2.isDisposed()) {
            return;
        }
        def = Math.max(0, Math.min(this.loadDefaultCameraIndex() != null ? this.loadDefaultCameraIndex() : 0, cameraCount - 1));
        var2_2.select(def);
        var2_2.setEnabled(true);
        var3_3.setEnabled(true);
        var4_4.setEnabled(true);
        var5_5.asyncExec(var6_6);
        var2_2.addListener(13, (Listener)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/swt/widgets/Event;)V, lambda$8(org.eclipse.swt.widgets.Display java.lang.Runnable org.eclipse.swt.widgets.Event ), (Lorg/eclipse/swt/widgets/Event;)V)((Display)var5_5, (Runnable)var6_6));
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$4(int var1_1, Display var2_2, Shell var3_3, int var4_4, Canvas var5_5, Image[] var6_6) {
        try {
            this.grabber = this.createGrabber(var1_1);
            if (this.grabber == null) {
                return;
            }
            this.grabber.start();
            if (true) ** GOTO lbl23
        }
        catch (Exception ex) {
            PatientCameraCaptureDialog.logger.error("Error starting video grabber: {}", (Object)ex.getMessage(), (Object)ex);
            var2_2.asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$5(org.eclipse.swt.widgets.Shell java.lang.Exception ), ()V)((PatientCameraCaptureDialog)this, (Shell)var3_3, (Exception)ex));
            return;
        }
        do {
            try {
                this.currentFrame = this.grabber.grab();
                if (this.currentFrame != null && (bufImg = this.converter.getBufferedImage(this.currentFrame)) != null) {
                    faceRect = FaceDetectionUtil.detectFace(bufImg = PatientCameraCaptureDialog.flipHorizontal(bufImg));
                    this.liveFaceRect = faceRect != null ? PatientCameraCaptureDialog.addPadding(faceRect, bufImg, 0.45) : null;
                    swtImg = new Image((Device)var2_2, ImageDataFactory.createFromAwt(bufImg));
                    var2_2.asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$6(org.eclipse.swt.widgets.Canvas org.eclipse.swt.graphics.Image[] org.eclipse.swt.graphics.Image ), ()V)((Canvas)var5_5, (Image[])var6_6, (Image)swtImg));
                }
                Thread.sleep(33L);
            }
            catch (Exception var7_9) {
                // empty catch block
            }
lbl23:
            // 3 sources

        } while (!var3_3.isDisposed() && this.streamGeneration.get() == var4_4);
    }

    private static /* synthetic */ void lambda$8(Display display, Runnable runnable, Event e) {
        display.asyncExec(runnable);
    }

    private /* synthetic */ void lambda$5(Shell shell, Exception exception) {
        if (!shell.isDisposed()) {
            this.showError(shell, Messages.PatientCameraCaptureDialog_CameraErrorTitle + exception.getMessage());
        }
    }

    private static /* synthetic */ void lambda$6(Canvas canvas, Image[] imageArray, Image image) {
        if (!canvas.isDisposed()) {
            Image old = imageArray[0];
            imageArray[0] = image;
            canvas.redraw();
            if (old != null && !old.isDisposed()) {
                old.dispose();
            }
        } else {
            image.dispose();
        }
    }
}

