/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.text.docx.util;

import ch.elexis.core.text.docx.util.DocxUtil;
import ch.elexis.core.text.docx.util.FindTextVisitor;
import ch.elexis.core.text.docx.util.StyleInfo;
import ch.elexis.core.text.docx.util.TextUtil;
import jakarta.xml.bind.JAXBElement;
import java.util.List;
import java.util.Optional;
import org.docx4j.TraversalUtil;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.com.microsoft.schemas.office.word.x2010.wordprocessingShape.CTTextboxInfo;
import org.docx4j.com.microsoft.schemas.office.word.x2010.wordprocessingShape.CTWordprocessingShape;
import org.docx4j.dml.CTLineProperties;
import org.docx4j.dml.CTNoFillProperties;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.CTNonVisualDrawingShapeProps;
import org.docx4j.dml.CTPoint2D;
import org.docx4j.dml.CTPositiveSize2D;
import org.docx4j.dml.CTPresetGeometry2D;
import org.docx4j.dml.CTPresetTextShape;
import org.docx4j.dml.CTShapeProperties;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.dml.STShapeType;
import org.docx4j.dml.STTextAnchoringType;
import org.docx4j.dml.STTextHorzOverflowType;
import org.docx4j.dml.STTextShapeType;
import org.docx4j.dml.STTextVertOverflowType;
import org.docx4j.dml.STTextVerticalType;
import org.docx4j.dml.STTextWrappingType;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.CTEffectExtent;
import org.docx4j.dml.wordprocessingDrawing.CTPosH;
import org.docx4j.dml.wordprocessingDrawing.CTPosV;
import org.docx4j.dml.wordprocessingDrawing.ObjectFactory;
import org.docx4j.dml.wordprocessingDrawing.STRelFromH;
import org.docx4j.dml.wordprocessingDrawing.STRelFromV;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.CTTxbxContent;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;

public class TextBoxUtil {
    static org.docx4j.wml.ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
    static ObjectFactory dmlwordprocessingDrawingObjectFactory = new ObjectFactory();
    static org.docx4j.dml.ObjectFactory dmlObjectFactory = new org.docx4j.dml.ObjectFactory();
    static org.docx4j.com.microsoft.schemas.office.word.x2010.wordprocessingShape.ObjectFactory mswordprocessingShapeObjectFactory = new org.docx4j.com.microsoft.schemas.office.word.x2010.wordprocessingShape.ObjectFactory();
    private static int txbxId = 1000;

    private static synchronized int getNextTxBxId() {
        return ++txbxId;
    }

    public static P pTextBox(int posx, int posy, int width, int height, int align) {
        P p = wmlObjectFactory.createP();
        R r = wmlObjectFactory.createR();
        p.getContent().add(r);
        RPr rpr = wmlObjectFactory.createRPr();
        r.setRPr(rpr);
        Drawing drawing = wmlObjectFactory.createDrawing();
        JAXBElement drawingWrapped = wmlObjectFactory.createRDrawing(drawing);
        Anchor anchor = dmlwordprocessingDrawingObjectFactory.createAnchor();
        anchor.setLayoutInCell(true);
        anchor.setAllowOverlap(true);
        anchor.setSimplePosAttr(Boolean.valueOf(false));
        anchor.setRelativeHeight(0xF000000L);
        CTPoint2D point2d = dmlObjectFactory.createCTPoint2D();
        point2d.setX(0L);
        point2d.setY(0L);
        anchor.setSimplePos(point2d);
        CTPosH posH = dmlwordprocessingDrawingObjectFactory.createCTPosH();
        posH.setRelativeFrom(STRelFromH.MARGIN);
        posH.setPosOffset(Integer.valueOf((int)UnitsOfMeasurement.twipToEMU((double)posx)));
        anchor.setPositionH(posH);
        CTPosV posV = dmlwordprocessingDrawingObjectFactory.createCTPosV();
        posV.setRelativeFrom(STRelFromV.PAGE);
        posV.setPosOffset(Integer.valueOf((int)UnitsOfMeasurement.twipToEMU((double)posy)));
        anchor.setPositionV(posV);
        CTPositiveSize2D extent = dmlObjectFactory.createCTPositiveSize2D();
        extent.setCx(UnitsOfMeasurement.twipToEMU((double)width));
        extent.setCy(UnitsOfMeasurement.twipToEMU((double)height));
        anchor.setExtent(extent);
        CTEffectExtent effectiveExtent = dmlwordprocessingDrawingObjectFactory.createCTEffectExtent();
        anchor.setEffectExtent(effectiveExtent);
        anchor.setWrapNone(dmlwordprocessingDrawingObjectFactory.createCTWrapNone());
        CTNonVisualDrawingProps docPr = dmlObjectFactory.createCTNonVisualDrawingProps();
        int nextTxBxId = TextBoxUtil.getNextTxBxId();
        docPr.setId((long)nextTxBxId);
        docPr.setName("Textfeld " + nextTxBxId);
        anchor.setDocPr(docPr);
        anchor.setCNvGraphicFramePr(dmlObjectFactory.createCTNonVisualGraphicFrameProperties());
        drawing.getAnchorOrInline().add(anchor);
        Graphic graphic = dmlObjectFactory.createGraphic();
        anchor.setGraphic(graphic);
        GraphicData graphicdata = dmlObjectFactory.createGraphicData();
        graphic.setGraphicData(graphicdata);
        CTNonVisualDrawingShapeProps cNvSpPr = dmlObjectFactory.createCTNonVisualDrawingShapeProps();
        cNvSpPr.setTxBox(Boolean.valueOf(true));
        graphicdata.setUri("http://schemas.microsoft.com/office/word/2010/wordprocessingShape");
        CTWordprocessingShape wpsp = mswordprocessingShapeObjectFactory.createCTWordprocessingShape();
        JAXBElement wpspWrapped = mswordprocessingShapeObjectFactory.createWsp(wpsp);
        graphicdata.getAny().add(wpspWrapped);
        graphicdata.getWordprocessingShape().setCNvSpPr(cNvSpPr);
        CTShapeProperties spPr = dmlObjectFactory.createCTShapeProperties();
        CTTransform2D xfrm = dmlObjectFactory.createCTTransform2D();
        CTPoint2D off = dmlObjectFactory.createCTPoint2D();
        off.setX(0L);
        off.setY(0L);
        xfrm.setOff(off);
        CTPositiveSize2D ext = dmlObjectFactory.createCTPositiveSize2D();
        ext.setCx(UnitsOfMeasurement.twipToEMU((double)width));
        ext.setCy(UnitsOfMeasurement.twipToEMU((double)height));
        xfrm.setExt(ext);
        spPr.setXfrm(xfrm);
        CTNoFillProperties noFill = dmlObjectFactory.createCTNoFillProperties();
        spPr.setNoFill(noFill);
        CTLineProperties ln = dmlObjectFactory.createCTLineProperties();
        noFill = dmlObjectFactory.createCTNoFillProperties();
        ln.setNoFill(noFill);
        spPr.setLn(ln);
        CTPresetGeometry2D prstGeom = dmlObjectFactory.createCTPresetGeometry2D();
        prstGeom.setPrst(STShapeType.RECT);
        spPr.setPrstGeom(prstGeom);
        graphicdata.getWordprocessingShape().setSpPr(spPr);
        CTTextboxInfo txbx = mswordprocessingShapeObjectFactory.createCTTextboxInfo();
        CTTxbxContent txbxcontent = wmlObjectFactory.createCTTxbxContent();
        P p2 = wmlObjectFactory.createP();
        txbxcontent.getContent().add(p2);
        PPr ppr2 = wmlObjectFactory.createPPr();
        DocxUtil.addAlign(ppr2, align);
        p2.setPPr(ppr2);
        ParaRPr pararpr2 = wmlObjectFactory.createParaRPr();
        ppr2.setRPr(pararpr2);
        R r2 = wmlObjectFactory.createR();
        p2.getContent().add(r2);
        RPr rpr2 = wmlObjectFactory.createRPr();
        r2.setRPr(rpr2);
        Text text = wmlObjectFactory.createText();
        JAXBElement textWrapped = wmlObjectFactory.createRT(text);
        r2.getContent().add(textWrapped);
        txbx.setTxbxContent(txbxcontent);
        graphicdata.getWordprocessingShape().setTxbx(txbx);
        CTTextBodyProperties bodyPr = dmlObjectFactory.createCTTextBodyProperties();
        bodyPr.setRot(Integer.valueOf(0));
        bodyPr.setSpcFirstLastPara(Boolean.valueOf(false));
        bodyPr.setVertOverflow(STTextVertOverflowType.OVERFLOW);
        bodyPr.setHorzOverflow(STTextHorzOverflowType.OVERFLOW);
        bodyPr.setVert(STTextVerticalType.HORZ);
        bodyPr.setWrap(STTextWrappingType.SQUARE);
        bodyPr.setLIns(Integer.valueOf(0));
        bodyPr.setTIns(Integer.valueOf(0));
        bodyPr.setRIns(Integer.valueOf(0));
        bodyPr.setBIns(Integer.valueOf(0));
        bodyPr.setNumCol(Integer.valueOf(1));
        bodyPr.setSpcCol(Integer.valueOf(0));
        bodyPr.setRtlCol(Boolean.valueOf(false));
        bodyPr.setFromWordArt(Boolean.valueOf(false));
        bodyPr.setAnchor(STTextAnchoringType.T);
        bodyPr.setAnchorCtr(Boolean.valueOf(false));
        bodyPr.setForceAA(Boolean.valueOf(false));
        bodyPr.setCompatLnSpc(Boolean.valueOf(true));
        CTPresetTextShape prstTxWarp = dmlObjectFactory.createCTPresetTextShape();
        prstTxWarp.setPrst(STTextShapeType.TEXT_NO_SHAPE);
        bodyPr.setPrstTxWarp(prstTxWarp);
        graphicdata.getWordprocessingShape().setBodyPr(bodyPr);
        r.getContent().add(drawingWrapped);
        return p;
    }

    private static Optional<Text> getTextFromBoxP(P textBox) {
        FindTextVisitor visitor = new FindTextVisitor();
        TraversalUtil.visit((Object)textBox, (TraversalUtilVisitor)visitor);
        List<Text> found = visitor.getFound();
        if (!found.isEmpty()) {
            return Optional.of(found.get(0));
        }
        return Optional.empty();
    }

    public static Object createTextBox(WordprocessingMLPackage currentDocument, int posx, int posy, int width, int height, String text, int align, StyleInfo currentStyleInfo) {
        posx = UnitsOfMeasurement.mmToTwip((float)posx);
        posy = UnitsOfMeasurement.mmToTwip((float)posy);
        width = UnitsOfMeasurement.mmToTwip((float)width);
        height = UnitsOfMeasurement.mmToTwip((float)height);
        P textBox = TextBoxUtil.pTextBox(posx, posy, width, height, align);
        currentDocument.getMainDocumentPart().getContent().add(textBox);
        Optional<Text> textElement = TextBoxUtil.getTextFromBoxP(textBox);
        if (textElement.isPresent()) {
            R r = (R)textElement.get().getParent();
            TextUtil.insertText(r, text, align, currentStyleInfo);
            return r;
        }
        throw new IllegalStateException("Created textbox without Text element");
    }
}

