/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IBillingSystemService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.test.initializer.TestDatabaseInitializer;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Money;
import java.time.LocalDate;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public abstract class AbstractTest {
    protected IModelService coreModelService;
    protected IContextService contextService;
    protected IUser user;
    protected IPerson person;
    protected IMandator mandator;
    protected IPatient patient;
    protected ICoverage coverage;
    protected IEncounter encounter;
    protected IArticle localArticle;
    public static final String KVG_NAME = Messages.Case_KVG_Short;
    public static final String UVG_NAME = Messages.Case_UVG_Short;
    public static final String MV_NAME = Messages.Fall_MV_Name;
    public static final String IV_NAME = Messages.Fall_IV_Name;
    private static final String KVG_REQUIREMENTS = Messages.Fall_KVGRequirements;
    public static final String UVG_REQUIREMENTS = Messages.Fall_UVGRequirements;
    public static final String CONST_TARMED_DRUCKER = Messages.Fall_TarmedPrinter;
    public static final String CONST_TARMED_LEISTUNG = Messages.Fall_TarmedLeistung;
    public static final String VVG_NAME = Messages.Fall_VVG_Name;
    public static final String PRIVATE_NAME = Messages.Case_Privat_Short;

    @Before
    public void before() {
        this.coreModelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.contextService = (IContextService)OsgiServiceUtil.getService(IContextService.class).get();
        this.contextService.setActiveUser(TestDatabaseInitializer.getUser());
        this.contextService.setActiveMandator(TestDatabaseInitializer.getMandant());
    }

    @After
    public void after() {
        List execute;
        int size;
        this.contextService.setActiveUser(null);
        if (this.encounter != null) {
            this.coreModelService.remove((Identifiable)this.encounter);
        }
        if (this.coverage != null) {
            this.coreModelService.remove((Identifiable)this.coverage);
        }
        if (this.localArticle != null) {
            this.coreModelService.remove((Identifiable)this.localArticle);
        }
        if (this.user != null) {
            this.coreModelService.remove((Identifiable)this.user);
        }
        if (this.person != null) {
            this.coreModelService.remove((Identifiable)this.person);
        }
        if (this.mandator != null) {
            this.coreModelService.remove((Identifiable)this.mandator);
        }
        if (this.patient != null) {
            this.coreModelService.remove((Identifiable)this.patient);
        }
        if ((size = (execute = this.coreModelService.getQuery(IPerson.class, true, true).execute()).size()) > 0) {
            LoggerFactory.getLogger(this.getClass()).warn("multiple IPerson [{}]", (Object)execute.size(), (Object)new Throwable());
        }
        OsgiServiceUtil.ungetService((Object)this.coreModelService);
        this.coreModelService = null;
    }

    public void createUserSetActiveInContext() {
        if (this.person == null) {
            this.createPerson();
        }
        this.user = (IUser)new IUserBuilder(this.coreModelService, "b_a_barracus", (IContact)this.person).buildAndSave();
        this.contextService.setActiveUser(this.user);
    }

    public IPerson createPerson() {
        LocalDate dob = LocalDate.of(1979, 7, 26);
        this.person = (IPerson)new IContactBuilder.PersonBuilder(this.coreModelService, "TestPerson", "TestPerson", dob, Gender.FEMALE).buildAndSave();
        Assert.assertTrue((boolean)this.person.isPerson());
        Assert.assertFalse((boolean)this.person.isPatient());
        Assert.assertFalse((boolean)this.person.isOrganization());
        Assert.assertFalse((boolean)this.person.isLaboratory());
        Assert.assertFalse((boolean)this.person.isMandator());
        return this.person;
    }

    public void createMandator() {
        this.mandator = (IMandator)new IContactBuilder.MandatorBuilder(this.coreModelService, "TestMandator", "TestMandator").buildAndSave();
        Assert.assertFalse((boolean)this.mandator.isPerson());
        Assert.assertFalse((boolean)this.mandator.isPatient());
        Assert.assertFalse((boolean)this.mandator.isOrganization());
        Assert.assertFalse((boolean)this.mandator.isLaboratory());
        Assert.assertTrue((boolean)this.mandator.isMandator());
    }

    public void createPatient() {
        LocalDate dob = LocalDate.of(2016, 9, 1);
        this.patient = (IPatient)new IContactBuilder.PatientBuilder(this.coreModelService, "TestPatient", "TestPatient", dob, Gender.MALE).buildAndSave();
        Assert.assertTrue((boolean)this.patient.isPerson());
        Assert.assertTrue((boolean)this.patient.isPatient());
        Assert.assertFalse((boolean)this.patient.isOrganization());
        Assert.assertFalse((boolean)this.patient.isLaboratory());
        Assert.assertFalse((boolean)this.patient.isMandator());
    }

    public void createCoverage() {
        IBillingSystemService billingSystemService = (IBillingSystemService)OsgiServiceUtil.getService(IBillingSystemService.class).get();
        billingSystemService.addOrModifyBillingSystem(KVG_NAME, CONST_TARMED_LEISTUNG, CONST_TARMED_DRUCKER, KVG_REQUIREMENTS, BillingLaw.KVG);
        billingSystemService.addOrModifyBillingSystem(UVG_NAME, CONST_TARMED_LEISTUNG, CONST_TARMED_DRUCKER, UVG_REQUIREMENTS, BillingLaw.UVG);
        if (this.patient == null) {
            this.createPatient();
        }
        this.coverage = new ICoverageBuilder(this.coreModelService, this.patient, "testCoverage", "testReason", "KVG").buildAndSave();
    }

    public void createEncounter() {
        if (this.coverage == null) {
            this.createCoverage();
        }
        if (this.mandator == null) {
            this.createMandator();
        }
        this.encounter = (IEncounter)new IEncounterBuilder(this.coreModelService, this.coverage, this.mandator).buildAndSave();
    }

    public void createLocalArticle() {
        this.localArticle = (IArticle)new IArticleBuilder(this.coreModelService, "test article", "123456789", ArticleTyp.EIGENARTIKEL).build();
        this.localArticle.setGtin("0000001111111");
        this.localArticle.setPackageSize(12);
        this.localArticle.setSellingSize(12);
        this.localArticle.setSellingPrice(new Money(150));
        this.localArticle.setPurchasePrice(new Money(100));
        this.coreModelService.save((Identifiable)this.localArticle);
    }
}

