/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.test.context;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class TestContext
implements IContext {
    private ConcurrentHashMap<String, Object> context;
    private TestContext parent;
    private final String STATION_IDENTIFIER = UUID.randomUUID().toString();

    public TestContext() {
        this(null, "root");
    }

    public TestContext(TestContext parent, String name) {
        this.context = new ConcurrentHashMap();
        this.parent = parent;
    }

    public <T> Optional<T> getTyped(Class<T> clazz) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(clazz.getName()));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getTyped(clazz);
        }
        return ret;
    }

    public void setTyped(Object object) {
        if (object != null) {
            Optional<Class<?>> modelInterface;
            if (object instanceof IUser) {
                Optional defaultMandator;
                IContact userContact = ((IUser)object).getAssignedContact();
                this.setNamed("ch.elexis.core.services.icontext.active.usercontact", userContact);
                Optional userService = OsgiServiceUtil.getService(IUserService.class);
                if (userService.isPresent() && (defaultMandator = ((IUserService)userService.get()).getDefaultExecutiveDoctorWorkingFor((IUser)object)).isPresent()) {
                    this.setTyped(defaultMandator.get());
                }
            }
            if ((modelInterface = this.getModelInterface(object)).isPresent()) {
                if (object.equals(this.context.get(modelInterface.get().getName()))) {
                    return;
                }
                this.context.put(modelInterface.get().getName(), object);
            } else {
                this.context.put(object.getClass().getName(), object);
            }
        }
    }

    private Optional<Class<?>> getModelInterface(Object object) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = object.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            if (interfaze.getName().startsWith("ch.elexis.core.model") && !interfaze.getName().contains("Identifiable")) {
                return Optional.of(interfaze);
            }
            ++n2;
        }
        return Optional.empty();
    }

    public void removeTyped(Class<?> clazz) {
        this.context.remove(clazz.getName());
    }

    public Optional<?> getNamed(String name) {
        Optional<Object> ret = Optional.ofNullable(this.context.get(name));
        if (!ret.isPresent() && this.parent != null) {
            ret = this.parent.getNamed(name);
        }
        if (ret.isPresent() && ret.get() instanceof Supplier) {
            return Optional.ofNullable(((Supplier)ret.get()).get());
        }
        return ret;
    }

    public void setNamed(String name, Object object) {
        if (object == null) {
            this.context.remove(name);
        } else {
            if (object.equals(this.context.get(name))) {
                return;
            }
            this.context.put(name, object);
        }
    }

    public void setParent(TestContext parent) {
        this.parent = parent;
    }

    public String getStationIdentifier() {
        return this.STATION_IDENTIFIER;
    }
}

