/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service;

import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IMessageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.tasks.internal.service.Task;
import ch.elexis.core.tasks.internal.service.TaskServiceUtil;
import ch.elexis.core.tasks.internal.service.quartz.QuartzExecutor;
import ch.elexis.core.tasks.internal.service.sysevents.SysEventWatcher;
import ch.elexis.core.tasks.internal.service.vfs.FilesystemChangeWatcher;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.ModelPackage;
import ch.elexis.core.tasks.model.OwnerTaskNotification;
import ch.elexis.core.tasks.model.TaskState;
import ch.elexis.core.tasks.model.TaskTriggerType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class TaskServiceImpl
implements ITaskService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IModelService taskModelService;
    private TaskServiceUtil util;
    private ExecutorService parallelExecutorService;
    private Map<String, ExecutorService> perRunnableSingletonExecutorService;
    private QuartzExecutor quartzExecutor;
    private FilesystemChangeWatcher fileSystemChangeWatcher;
    private SysEventWatcher sysEventWatcher;
    private List<ITask> triggeredTasks;
    @Reference
    private IContextService contextService;
    @Reference
    private IMessageService messageService;
    @Reference
    private IVirtualFilesystemService virtualFilesystemService;
    @Reference
    private IAccessControlService accessControl;
    private List<IIdentifiedRunnable> identifiedRunnables = Collections.synchronizedList(new ArrayList());
    private Map<String, IIdentifiedRunnableFactory> runnableIdToFactoryMap = Collections.synchronizedMap(new HashMap());
    private List<IIdentifiedRunnableFactory> runnableWithContextFactories;

    @Reference(target="(service.model.name=ch.elexis.core.tasks.model)")
    private void setModelService(IModelService modelService) {
        this.taskModelService = modelService;
    }

    @Override
    public void bindIIdentifiedRunnableFactory(IIdentifiedRunnableFactory runnableWithContextFactory) {
        if (this.runnableWithContextFactories == null) {
            this.runnableWithContextFactories = new ArrayList<IIdentifiedRunnableFactory>();
        }
        this.logger.info("Binding " + runnableWithContextFactory.getClass().getName());
        this.runnableWithContextFactories.add(runnableWithContextFactory);
        try {
            List providedRunnables = runnableWithContextFactory.getProvidedRunnables();
            for (IIdentifiedRunnable iIdentifiedRunnable : providedRunnables) {
                this.runnableIdToFactoryMap.put(iIdentifiedRunnable.getId(), runnableWithContextFactory);
                this.identifiedRunnables.add(iIdentifiedRunnable);
                this.loadIncurredForRunnable(iIdentifiedRunnable);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error binding [{}], skipping.", (Object)runnableWithContextFactory.getClass().getName(), (Object)e);
            return;
        }
    }

    @Override
    public void unbindIIdentifiedRunnableFactory(IIdentifiedRunnableFactory runnableWithContextFactory) {
        this.logger.debug("Unbinding " + runnableWithContextFactory.getClass().getName());
        this.runnableWithContextFactories.remove(runnableWithContextFactory);
        List providedRunnables = runnableWithContextFactory.getProvidedRunnables();
        for (IIdentifiedRunnable iIdentifiedRunnable : providedRunnables) {
            this.runnableIdToFactoryMap.remove(iIdentifiedRunnable.getId());
            this.identifiedRunnables.remove(iIdentifiedRunnable);
            this.unloadIncurredForRunnable(iIdentifiedRunnable);
        }
    }

    public TaskServiceImpl() {
        this.triggeredTasks = Collections.synchronizedList(new ArrayList());
        this.parallelExecutorService = Executors.newCachedThreadPool();
        this.perRunnableSingletonExecutorService = new HashMap<String, ExecutorService>();
        this.sysEventWatcher = new SysEventWatcher();
        this.util = new TaskServiceUtil();
    }

    @Deactivate
    private void deactivateComponent() {
        List<ITask> runningTasks = this.getRunningTasks();
        long start = System.currentTimeMillis();
        while (!runningTasks.isEmpty() && System.currentTimeMillis() - start < 30000L) {
            for (ITask task2 : runningTasks) {
                IProgressMonitor progressMonitor = task2.getProgressMonitor();
                if (progressMonitor.isCanceled()) continue;
                this.logger.info("Canceling " + task2.getLabel());
                task2.getProgressMonitor().setCanceled(true);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException task2) {
                // empty catch block
            }
            runningTasks = this.getRunningTasks();
            this.logger.info("Waiting max 30 seconds for tasks to gracefully stop");
        }
        this.getRunningTasks().forEach(task -> this.logger.warn("Could not gracefully stop task " + task.getLabel()));
        if (this.quartzExecutor != null) {
            try {
                this.quartzExecutor.shutdown();
                this.quartzExecutor = null;
            }
            catch (SchedulerException e2) {
                this.logger.warn("Error stopping quartz scheduler", (Throwable)e2);
            }
        }
        this.parallelExecutorService.shutdown();
        this.perRunnableSingletonExecutorService.forEach((c, e) -> e.shutdown());
        if (this.fileSystemChangeWatcher != null) {
            this.fileSystemChangeWatcher.stopPolling();
        }
    }

    private synchronized void assertFilesystemChangeWatcher() {
        if (this.fileSystemChangeWatcher == null) {
            this.fileSystemChangeWatcher = new FilesystemChangeWatcher(this, this.virtualFilesystemService, this.accessControl);
        }
    }

    private synchronized void assertQuartzExecutor() throws TaskException {
        if (this.quartzExecutor == null) {
            this.quartzExecutor = new QuartzExecutor();
            try {
                this.quartzExecutor.start();
            }
            catch (SchedulerException e) {
                this.quartzExecutor = null;
                throw new TaskException(8, "Error starting quartz scheduler", (Throwable)e);
            }
        }
    }

    @Override
    public boolean assertIncurOnThisStation(ITaskDescriptor taskDescriptor) {
        if (taskDescriptor != null && !taskDescriptor.isDeleted() && taskDescriptor.isActive()) {
            String runner = taskDescriptor.getRunner();
            if (StringUtils.isNotBlank((CharSequence)runner)) {
                return StringUtils.equalsIgnoreCase((CharSequence)runner, (CharSequence)this.contextService.getStationIdentifier());
            }
            return true;
        }
        return false;
    }

    private void loadIncurredForRunnable(IIdentifiedRunnable identifiedRunnable) {
        List<ITaskDescriptor> taskDescriptors = this.util.loadForIdentifiedRunnable(identifiedRunnable, this.taskModelService, this.contextService);
        for (ITaskDescriptor iTaskDescriptor : taskDescriptors) {
            try {
                this.logger.info("incurring task descriptor [{}] reference id [{}]", (Object)iTaskDescriptor.getId(), (Object)iTaskDescriptor.getReferenceId());
                this.incur(iTaskDescriptor);
            }
            catch (TaskException e) {
                this.logger.warn("Can not incur taskdescriptor [{}]", (Object)iTaskDescriptor.getId(), (Object)e);
            }
        }
    }

    private void unloadIncurredForRunnable(IIdentifiedRunnable identifiedRunnable) {
        List<ITaskDescriptor> taskDescriptors = this.util.loadForIdentifiedRunnable(identifiedRunnable, this.taskModelService, this.contextService);
        for (ITaskDescriptor iTaskDescriptor : taskDescriptors) {
            try {
                this.logger.info("releasing task descriptor [{}] reference id [{}]", (Object)iTaskDescriptor.getId(), (Object)iTaskDescriptor.getReferenceId());
                this.release(iTaskDescriptor);
            }
            catch (TaskException e) {
                this.logger.warn("Can not release taskdescriptor [{}]", (Object)iTaskDescriptor.getId(), (Object)e);
            }
        }
    }

    private void incur(ITaskDescriptor taskDescriptor) throws TaskException {
        boolean isToIncurOnThisStation = this.assertIncurOnThisStation(taskDescriptor);
        if (!isToIncurOnThisStation) {
            return;
        }
        this.instantiateRunnableById(taskDescriptor.getIdentifiedRunnableId());
        if (TaskTriggerType.FILESYSTEM_CHANGE == taskDescriptor.getTriggerType()) {
            this.assertFilesystemChangeWatcher();
            this.fileSystemChangeWatcher.incur(taskDescriptor);
        } else if (TaskTriggerType.CRON == taskDescriptor.getTriggerType()) {
            this.assertQuartzExecutor();
            this.quartzExecutor.incur(this, taskDescriptor);
        } else if (TaskTriggerType.MANUAL != taskDescriptor.getTriggerType() && TaskTriggerType.OTHER_TASK != taskDescriptor.getTriggerType()) {
            if (TaskTriggerType.SYSTEM_EVENT == taskDescriptor.getTriggerType()) {
                this.sysEventWatcher.incur(taskDescriptor);
            } else {
                throw new TaskException(8, "Trigger type not yet implemented [" + String.valueOf((Object)taskDescriptor.getTriggerType()) + "]");
            }
        }
    }

    private void release(ITaskDescriptor taskDescriptor) throws TaskException {
        if (TaskTriggerType.FILESYSTEM_CHANGE == taskDescriptor.getTriggerType()) {
            this.assertFilesystemChangeWatcher();
            this.fileSystemChangeWatcher.release(taskDescriptor);
        } else if (TaskTriggerType.CRON == taskDescriptor.getTriggerType()) {
            if (this.quartzExecutor != null) {
                this.quartzExecutor.release(taskDescriptor);
            }
        } else if (TaskTriggerType.SYSTEM_EVENT == taskDescriptor.getTriggerType()) {
            this.sysEventWatcher.release(taskDescriptor);
        }
    }

    @Override
    public void refresh(ITaskDescriptor taskDescriptor) throws TaskException {
        boolean toIncurOnThisStation = this.assertIncurOnThisStation(taskDescriptor);
        Optional<ITaskDescriptor> incurredTask = this.getIncurredTasks().stream().filter(td -> td.getId().equals(taskDescriptor.getId())).findFirst();
        if (incurredTask.isPresent()) {
            if (toIncurOnThisStation) {
                if (taskDescriptor.getLastupdate() > incurredTask.get().getLastupdate()) {
                    this.logger.info("(refresh) taskDesc change [{}/{}], rel/inc", (Object)taskDescriptor.getReferenceId(), (Object)taskDescriptor.getId());
                    this.release(taskDescriptor);
                    this.incur(taskDescriptor);
                }
            } else {
                this.logger.info("(refresh) taskDesc release [{}/{}], rel/inc", (Object)taskDescriptor.getReferenceId(), (Object)taskDescriptor.getId());
                this.release(taskDescriptor);
            }
        } else if (toIncurOnThisStation) {
            this.logger.info("(refresh) taskDesc incur [{}/{}], rel/inc", (Object)taskDescriptor.getReferenceId(), (Object)taskDescriptor.getId());
            this.incur(taskDescriptor);
        }
    }

    @Override
    public ITaskDescriptor createTaskDescriptor(IIdentifiedRunnable identifiedRunnable) throws TaskException {
        if (identifiedRunnable == null) {
            throw new TaskException(5);
        }
        ITaskDescriptor taskDescriptor = (ITaskDescriptor)this.taskModelService.create(ITaskDescriptor.class);
        taskDescriptor.setIdentifiedRunnableId(identifiedRunnable.getId());
        taskDescriptor.setRunContext(identifiedRunnable.getDefaultRunContext());
        String stationIdentifier = this.contextService.getRootContext().getStationIdentifier();
        taskDescriptor.setRunner(StringUtils.abbreviate((String)stationIdentifier, (int)64));
        taskDescriptor.setReferenceId("" + System.currentTimeMillis());
        this.contextService.getActiveUser().ifPresent(u -> taskDescriptor.setOwner((IUser)u));
        this.saveTaskDescriptor(taskDescriptor);
        return taskDescriptor;
    }

    @Override
    public boolean removeTaskDescriptor(ITaskDescriptor taskDescriptor) throws TaskException {
        if (taskDescriptor == null) {
            throw new TaskException(5);
        }
        this.setActive(taskDescriptor, false);
        IQuery taskQuery = this.taskModelService.getQuery(ITask.class, true);
        taskQuery.and((EStructuralFeature)ModelPackage.Literals.ITASK__TASK_DESCRIPTOR, IQuery.COMPARATOR.EQUALS, (Object)taskDescriptor);
        List execute = taskQuery.execute();
        execute.stream().forEach(task -> this.taskModelService.remove((Identifiable)task));
        this.taskModelService.remove((Identifiable)taskDescriptor);
        return true;
    }

    void notify(ITask task) {
        if (task.isFinished()) {
            this.triggeredTasks.remove(task);
            ITaskDescriptor taskDescriptor = task.getTaskDescriptor();
            OwnerTaskNotification ownerNotification = taskDescriptor.getOwnerNotification();
            IUser owner = taskDescriptor.getOwner();
            TaskState state = task.getState();
            if (OwnerTaskNotification.WHEN_FINISHED == ownerNotification || OwnerTaskNotification.WHEN_FINISHED_FAILED == ownerNotification && (TaskState.FAILED == state || TaskState.COMPLETED_WARN == state)) {
                if (owner != null) {
                    this.sendMessageToOwner(task, owner, state);
                } else {
                    this.logger.warn("[{}] requested owner notification, but owner is null", (Object)task.getTaskDescriptor().getId());
                }
            }
        }
    }

    private void sendMessageToOwner(ITask task, IUser owner, TaskState state) {
        String resultText;
        TransientMessage message = this.messageService.prepare("Task-Service@" + this.contextService.getRootContext().getStationIdentifier(), "internal:" + owner.getId());
        message.addMessageCode("senderSubId", "tasks.taskservice");
        message.setSenderAcceptsAnswer(false);
        if (TaskState.FAILED == state) {
            resultText = (String)task.getResult().get("exceptionMessage");
            message.addMessageCode("severity", "error");
        } else {
            String severity = TaskState.COMPLETED_WARN == state ? "warn" : "info";
            resultText = (String)task.getResult().get("resultData");
            message.addMessageCode("severity", severity);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(task.getLabel());
        if (StringUtils.isNotBlank((CharSequence)resultText)) {
            sb.append("\n" + resultText);
        }
        message.setMessageText(sb.toString());
        ObjectStatus status = this.messageService.send(message);
        if (!status.isOK()) {
            this.logger.warn("Could not send message to owner [{}]", (Object)status.getMessage());
        }
    }

    @Override
    public ITask triggerSync(ITaskDescriptor taskDescriptor, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext) throws TaskException {
        return this.trigger(taskDescriptor, progressMonitor, triggerType, runContext, true);
    }

    @Override
    public ITask trigger(ITaskDescriptor taskDescriptor, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext) throws TaskException {
        return this.trigger(taskDescriptor, progressMonitor, triggerType, runContext, false);
    }

    public ITask trigger(ITaskDescriptor taskDescriptor, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext, boolean sync) throws TaskException {
        ITaskDescriptor _taskDescriptorChanged = this.checkForTaskDescriptorChanges(taskDescriptor);
        if (_taskDescriptorChanged != null) {
            this.release(taskDescriptor);
            this.incur(_taskDescriptorChanged);
            return this.trigger(_taskDescriptorChanged, progressMonitor, triggerType, runContext, sync);
        }
        if (sync && triggerType != TaskTriggerType.MANUAL) {
            throw new IllegalArgumentException("OnlyTriggerType MANUAL can be executed sync");
        }
        if (triggerType == TaskTriggerType.OTHER_TASK && TaskTriggerType.OTHER_TASK != taskDescriptor.getTriggerType()) {
            throw new TaskException(1, "Task Descriptor [" + taskDescriptor.getId() + "] is not TriggerType OTHER_TASK");
        }
        if (!taskDescriptor.isActive() && TaskTriggerType.MANUAL != triggerType) {
            throw new TaskException(1, "Task Descriptor [" + taskDescriptor.getId() + "] is not active");
        }
        if (sync) {
            runContext = new HashMap<String, String>(runContext);
            runContext.put("isTriggerSync", Boolean.TRUE.toString());
        }
        this.logger.info("[{}] trigger taskDesc [{}/{}] runContext [{}]", new Object[]{triggerType, taskDescriptor.getReferenceId(), taskDescriptor.getId(), runContext});
        Task task = new Task(taskDescriptor, triggerType, progressMonitor, runContext);
        task.setSystem(taskDescriptor.isSystem());
        this.accessControl.doPrivileged(() -> task.setState(TaskState.QUEUED));
        String identifiedRunnableId = taskDescriptor.getIdentifiedRunnableId();
        boolean singletonRunnable = this.instantiateRunnableById(identifiedRunnableId).isSingleton();
        try {
            if (sync) {
                task.run();
            } else {
                if (singletonRunnable || taskDescriptor.isSingleton()) {
                    ExecutorService executorService;
                    if (!this.perRunnableSingletonExecutorService.containsKey(identifiedRunnableId)) {
                        executorService = Executors.newSingleThreadExecutor();
                        this.perRunnableSingletonExecutorService.put(identifiedRunnableId, executorService);
                    }
                    executorService = this.perRunnableSingletonExecutorService.get(identifiedRunnableId);
                    executorService.execute(task);
                } else {
                    this.parallelExecutorService.execute(task);
                }
                this.triggeredTasks.add(task);
            }
        }
        catch (RejectedExecutionException re) {
            this.accessControl.doPrivileged(() -> task.setState(TaskState.CANCELLED));
            throw new TaskException(1, (Throwable)re);
        }
        return task;
    }

    private ITaskDescriptor checkForTaskDescriptorChanges(ITaskDescriptor taskDescriptor) throws TaskException {
        Optional lastUpdate = this.taskModelService.executeNativeQuery("SELECT lastupdate FROM TASKDESCRIPTOR WHERE ID = '" + taskDescriptor.getId() + "'").findFirst();
        if (lastUpdate.isPresent() && lastUpdate.get().equals(taskDescriptor.getLastupdate())) {
            return null;
        }
        this.logger.info("[{}] detected taskDesc change [{}/{}], reloading", new Object[]{taskDescriptor.getTriggerType(), taskDescriptor.getReferenceId(), taskDescriptor.getId()});
        ITaskDescriptor changedTaskDescriptor = this.taskModelService.load(taskDescriptor.getId(), ITaskDescriptor.class, true, true).orElse(null);
        if (changedTaskDescriptor == null || changedTaskDescriptor.isDeleted()) {
            this.logger.warn("[{}] taskDesc not loadable or deleted [{} -> {}], releasing", new Object[]{taskDescriptor.getTriggerType(), taskDescriptor.getId(), changedTaskDescriptor != null ? changedTaskDescriptor.getId() : "null"});
            this.release(taskDescriptor);
            throw new TaskException(4, "TaskDescriptor not loadable or deleted, releasing it");
        }
        return changedTaskDescriptor;
    }

    @Override
    public ITask trigger(String taskDescriptorIdOrReferenceId, IProgressMonitor progressMonitor, TaskTriggerType triggerType, Map<String, String> runContext) throws TaskException {
        Optional<ITaskDescriptor> taskDescriptor = this.findTaskDescriptorByIdOrReferenceId(taskDescriptorIdOrReferenceId);
        if (taskDescriptor.isPresent()) {
            return this.trigger(taskDescriptor.get(), progressMonitor, triggerType, runContext);
        }
        throw new TaskException(1, "Could not find task descriptor reference id [" + taskDescriptorIdOrReferenceId + "]");
    }

    @Override
    public IIdentifiedRunnable instantiateRunnableById(String runnableId) throws TaskException {
        if (runnableId == null || runnableId.length() == 0) {
            throw new TaskException(2);
        }
        IIdentifiedRunnableFactory iIdentifiedRunnableFactory = this.runnableIdToFactoryMap.get(runnableId);
        if (iIdentifiedRunnableFactory != null) {
            List providedRunnables = iIdentifiedRunnableFactory.getProvidedRunnables();
            for (IIdentifiedRunnable iIdentifiedRunnable : providedRunnables) {
                if (!runnableId.equalsIgnoreCase(iIdentifiedRunnable.getId())) continue;
                return iIdentifiedRunnable;
            }
        }
        Object reason = iIdentifiedRunnableFactory == null ? "no registered factory found" : "runnable id not found in factory [" + iIdentifiedRunnableFactory.getClass().getName() + "]";
        throw new TaskException(3, "Could not instantiate runnable id [" + runnableId + "]: " + (String)reason);
    }

    @Override
    public void saveTaskDescriptor(ITaskDescriptor taskDescriptor) throws TaskException {
        try {
            this.taskModelService.save((Identifiable)taskDescriptor);
        }
        catch (IllegalStateException e) {
            throw new TaskException(4, (Throwable)e);
        }
    }

    @Override
    public void setActive(ITaskDescriptor taskDescriptor, boolean active) throws TaskException {
        if (taskDescriptor.isActive() == active) {
            return;
        }
        if (active) {
            this.validateTaskDescriptor(taskDescriptor);
        }
        taskDescriptor.setActive(active);
        this.saveTaskDescriptor(taskDescriptor);
        if (active) {
            this.incur(taskDescriptor);
        } else {
            this.release(taskDescriptor);
        }
    }

    private void validateTaskDescriptor(ITaskDescriptor taskDescriptor) throws TaskException {
        IIdentifiedRunnable runnable = this.instantiateRunnableById(taskDescriptor.getIdentifiedRunnableId());
        HashMap defaultRunContext = new HashMap(runnable.getDefaultRunContext());
        if (TaskTriggerType.OTHER_TASK == taskDescriptor.getTriggerType()) {
            return;
        }
        if (TaskTriggerType.SYSTEM_EVENT == taskDescriptor.getTriggerType()) {
            return;
        }
        if (TaskTriggerType.FILESYSTEM_CHANGE == taskDescriptor.getTriggerType()) {
            this.assertFilesystemChangeWatcher();
            defaultRunContext.remove("url");
            this.fileSystemChangeWatcher.validate(taskDescriptor);
        }
        Set entrySet = defaultRunContext.entrySet();
        for (Map.Entry entry : entrySet) {
            Serializable value;
            if (!"missingRequired".equals(entry.getValue()) || (value = taskDescriptor.getRunContext().get(entry.getKey())) != null && !"missingRequired".equals(value)) continue;
            throw new TaskException(5, "Missing required parameter [" + (String)entry.getKey() + "]");
        }
        if (taskDescriptor.getOwner() == null) {
            throw new TaskException(5, "Missing owner");
        }
    }

    @Override
    public List<IIdentifiedRunnable> getIdentifiedRunnables() {
        return this.identifiedRunnables;
    }

    @Override
    public Optional<ITaskDescriptor> findTaskDescriptorByIdOrReferenceId(String idOrReferenceId) {
        IQuery query = this.taskModelService.getQuery(ITaskDescriptor.class, true, false);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__ID, IQuery.COMPARATOR.EQUALS, (Object)idOrReferenceId);
        query.or((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__REFERENCE_ID, IQuery.COMPARATOR.EQUALS, (Object)idOrReferenceId);
        return query.executeSingleResult();
    }

    @Override
    public List<ITaskDescriptor> findTaskDescriptorByIIdentifiedRunnableId(String runnableId) {
        IQuery query = this.taskModelService.getQuery(ITaskDescriptor.class, true, false);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK_DESCRIPTOR__IDENTIFIED_RUNNABLE_ID, IQuery.COMPARATOR.EQUALS, (Object)runnableId);
        return query.execute();
    }

    @Override
    public Optional<ITask> findLatestExecution(ITaskDescriptor taskDescriptor) {
        IQuery query = this.taskModelService.getQuery(ITask.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ITASK__TASK_DESCRIPTOR, IQuery.COMPARATOR.EQUALS, (Object)taskDescriptor);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.DESC);
        query.limit(1);
        List result = query.execute();
        return result.isEmpty() ? Optional.empty() : Optional.of((ITask)result.get(0));
    }

    @Override
    public List<ITask> getRunningTasks() {
        return new ArrayList<ITask>(this.triggeredTasks);
    }

    @Override
    public List<ITaskDescriptor> getIncurredTasks() {
        Set<String[]> incurred;
        ArrayList<ITaskDescriptor> incurredTaskDescriptors = new ArrayList<ITaskDescriptor>();
        if (this.quartzExecutor != null) {
            incurred = this.quartzExecutor.getIncurred();
            incurred.stream().forEach(i -> {
                ITaskDescriptor taskDescriptor = this.taskModelService.load(i[0], ITaskDescriptor.class).orElse(null);
                if (taskDescriptor != null) {
                    taskDescriptor.getTransientData().put("cron-next-exectime", i[1]);
                    incurredTaskDescriptors.add(taskDescriptor);
                }
            });
        }
        if (this.fileSystemChangeWatcher != null) {
            incurred = this.fileSystemChangeWatcher.getIncurred();
            incurred.stream().forEach(i -> {
                ITaskDescriptor taskDescriptor = this.taskModelService.load(i[0], ITaskDescriptor.class).orElse(null);
                if (taskDescriptor != null) {
                    taskDescriptor.getTransientData().put("url", i[1]);
                    taskDescriptor.getTransientData().put("file-extension-filter", i[2]);
                    incurredTaskDescriptors.add(taskDescriptor);
                }
            });
        }
        return incurredTaskDescriptors;
    }
}

