/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.internal;

import ch.elexis.core.spotlight.ISpotlightResult;
import ch.elexis.core.spotlight.ISpotlightResultEntry;
import ch.elexis.core.spotlight.internal.SpotlightResultEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SpotlightResult
implements ISpotlightResult {
    private Set<ISpotlightResultEntry> patientEntries = Collections.synchronizedSet(new HashSet());
    private Set<ISpotlightResultEntry> encounterEntries = Collections.synchronizedSet(new HashSet());
    private Set<ISpotlightResultEntry> documentEntries = Collections.synchronizedSet(new HashSet());
    private Set<ISpotlightResultEntry> letterEntries = Collections.synchronizedSet(new HashSet());
    private Set<ISpotlightResultEntry.Category> usedCategories = new HashSet<ISpotlightResultEntry.Category>(4);

    @Override
    public void addEntry(ISpotlightResultEntry.Category category, String label, String storeToString, Object loadedObject) {
        SpotlightResultEntry entry = new SpotlightResultEntry(category, label, storeToString, loadedObject);
        switch (category) {
            case PATIENT: {
                this.patientEntries.add(entry);
                break;
            }
            case DOCUMENT: {
                this.documentEntries.add(entry);
                break;
            }
            case ENCOUNTER: {
                this.encounterEntries.add(entry);
                break;
            }
            case LETTER: {
                this.letterEntries.add(entry);
                break;
            }
        }
    }

    @Override
    public void clear() {
        this.patientEntries.clear();
        this.encounterEntries.clear();
        this.documentEntries.clear();
        this.letterEntries.clear();
    }

    @Override
    public Set<ISpotlightResultEntry.Category> hasResultsIn() {
        this.usedCategories.clear();
        if (!this.patientEntries.isEmpty()) {
            this.usedCategories.add(ISpotlightResultEntry.Category.PATIENT);
        }
        if (!this.encounterEntries.isEmpty()) {
            this.usedCategories.add(ISpotlightResultEntry.Category.ENCOUNTER);
        }
        if (!this.documentEntries.isEmpty()) {
            this.usedCategories.add(ISpotlightResultEntry.Category.DOCUMENT);
        }
        if (!this.letterEntries.isEmpty()) {
            this.usedCategories.add(ISpotlightResultEntry.Category.LETTER);
        }
        return this.usedCategories;
    }

    @Override
    public Set<ISpotlightResultEntry> getResultPerCategory(ISpotlightResultEntry.Category category) {
        switch (category) {
            case PATIENT: {
                return this.patientEntries;
            }
            case ENCOUNTER: {
                return this.encounterEntries;
            }
            case DOCUMENT: {
                return this.documentEntries;
            }
            case LETTER: {
                return this.letterEntries;
            }
        }
        return Collections.emptySet();
    }
}

