/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.internal.ready;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SpotlightReadyRefreshTimerTask
extends TimerTask {
    private static String NO_NEXT_APPOINTMENT_LABEL = "Heute keine weiteren Termine";
    private long lastRunTime;
    private IContextService contextService;
    private IModelService coreModelService;
    private IAppointmentService appointmentService;
    private Map<String, Area> appointmentUserAreas;
    private IAppointment nextAppointment;
    private String nextAppointmentLabel;
    private Long newLabValuesCount;
    private Long newDocumentsCount;
    private static final String QUERY_TEMPLATE_INBOX = "SELECT ID FROM at_medevit_elexis_inbox WHERE deleted = '0' AND mandant ='%s' AND state = '0' AND object LIKE '%s%%' LIMIT 1001";

    public SpotlightReadyRefreshTimerTask(IContextService contextService, IModelService coreModelService, IAppointmentService appointmentService) {
        this.contextService = contextService;
        this.coreModelService = coreModelService;
        this.appointmentService = appointmentService;
        this.nextAppointmentLabel = NO_NEXT_APPOINTMENT_LABEL;
        this.appointmentUserAreas = new HashMap<String, Area>();
    }

    @Optional
    @Inject
    public void activeUser(IUser user) {
        if (user != null) {
            this.appointmentService.getAreas().forEach(entry -> {
                String contactId = entry.getContactId();
                if (StringUtils.isNotBlank((CharSequence)contactId) && entry.getType() == AreaType.CONTACT) {
                    this.appointmentUserAreas.put(contactId, (Area)entry);
                }
            });
        } else {
            this.appointmentUserAreas.clear();
        }
    }

    @Override
    public void run() {
        this.lastRunTime = System.currentTimeMillis();
        this.refreshNextAppointment();
        this.refreshReminders();
        this.refreshOpenLabValues();
        this.refreshOpenDocuments();
    }

    private void refreshReminders() {
    }

    private void refreshOpenDocuments() {
        String mandatorId = this.contextService.getActiveMandator().map(m -> m.getId()).orElse(null);
        if (mandatorId != null) {
            String query = String.format(QUERY_TEMPLATE_INBOX, mandatorId, "ch.elexis.omnivore");
            this.newDocumentsCount = this.coreModelService.executeNativeQuery(query).count();
        } else {
            this.newDocumentsCount = null;
        }
    }

    private void refreshOpenLabValues() {
        String mandatorId = this.contextService.getActiveMandator().map(m -> m.getId()).orElse(null);
        if (mandatorId != null) {
            String query = String.format(QUERY_TEMPLATE_INBOX, mandatorId, "ch.elexis.data.labresult");
            this.newLabValuesCount = this.coreModelService.executeNativeQuery(query).count();
        } else {
            this.newLabValuesCount = null;
        }
    }

    private void refreshNextAppointment() {
        Area userArea;
        IContact userContact = this.contextService.getActiveUserContact().orElse(null);
        if (userContact != null && (userArea = this.appointmentUserAreas.get(userContact.getId())) != null) {
            IQuery nextAppointmentQuery = this.coreModelService.getQuery(IAppointment.class, true, false);
            nextAppointmentQuery.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SCHEDULE, IQuery.COMPARATOR.EQUALS, (Object)userArea.getName());
            LocalDateTime now = LocalDateTime.now();
            int minuteOfDay = now.getHour() * 60 + now.getMinute();
            nextAppointmentQuery.and("Tag", IQuery.COMPARATOR.EQUALS, (Object)now.toLocalDate());
            nextAppointmentQuery.and("Beginn", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)minuteOfDay);
            nextAppointmentQuery.limit(1);
            nextAppointmentQuery.orderBy("Beginn", IQuery.ORDER.ASC);
            this.nextAppointment = nextAppointmentQuery.executeSingleResult().orElse(null);
            this.nextAppointmentLabel = this.nextAppointment != null ? this.nextAppointment.getLabel() : NO_NEXT_APPOINTMENT_LABEL;
        }
    }

    public IAppointment getNextAppointment() {
        return this.nextAppointment;
    }

    public String getNextAppointmentLabel() {
        return this.nextAppointmentLabel;
    }

    public long getInfoAgeInSeconds() {
        return (System.currentTimeMillis() - this.lastRunTime) / 1000L;
    }

    @Nullable
    public Long getNewLabValuesCount() {
        return this.newLabValuesCount;
    }

    @Nullable
    public Long getNewDocumentsCount() {
        return this.newDocumentsCount;
    }
}

