/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.controls;

import ch.elexis.core.spotlight.ISpotlightResult;
import ch.elexis.core.spotlight.ISpotlightResultEntry;
import ch.elexis.core.spotlight.ISpotlightService;
import ch.elexis.core.spotlight.ui.controls.SpolightResultListContentProvider;
import ch.elexis.core.spotlight.ui.controls.SpotlightResultDetailComposite;
import ch.elexis.core.spotlight.ui.controls.SpotlightResultLabelProvider;
import ch.elexis.core.spotlight.ui.internal.SpotlightShell;
import ch.elexis.core.spotlight.ui.internal.SpotlightUiUtil;
import java.util.function.Consumer;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SpotlightResultListComposite
extends Composite {
    private static Font categoryFont;
    private SpotlightResultDetailComposite resultDetailComposite;
    private TableViewer tvSpotlightResults;
    private Table tableSpotlightResults;
    private SpotlightUiUtil uiUtil;

    public SpotlightResultListComposite(Composite parent, int style, ISpotlightService spotlightService, SpotlightUiUtil uiUtil) {
        super(parent, style);
        this.uiUtil = uiUtil;
        SpotlightShell _spotlightShell = (SpotlightShell)this.getShell();
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tvSpotlightResults = new TableViewer(composite, 65536);
        this.tableSpotlightResults = this.tvSpotlightResults.getTable();
        this.tableSpotlightResults.setBackground(parent.getBackground());
        TableViewerColumn tvcIcon = new TableViewerColumn(this.tvSpotlightResults, 0);
        TableColumn tcIcon = tvcIcon.getColumn();
        tcl_composite.setColumnData((Widget)tcIcon, (ColumnLayoutData)new ColumnPixelData(20, false, false));
        TableViewerColumn tvcLabel = new TableViewerColumn(this.tvSpotlightResults, 0);
        TableColumn tcLabel = tvcLabel.getColumn();
        tcl_composite.setColumnData((Widget)tcLabel, (ColumnLayoutData)new ColumnWeightData(1, 20, false));
        this.tvSpotlightResults.setContentProvider((IContentProvider)new SpolightResultListContentProvider());
        if (categoryFont == null) {
            FontData[] fontData = parent.getFont().getFontData();
            fontData[0].setHeight(8);
            categoryFont = new Font((Device)this.getDisplay(), fontData[0]);
        }
        SpotlightResultLabelProvider srllp = new SpotlightResultLabelProvider(parent.getFont(), categoryFont);
        this.tvSpotlightResults.setLabelProvider((IBaseLabelProvider)srllp);
        this.tableSpotlightResults.addListener(1, event -> {
            int keyCode = event.keyCode;
            switch (keyCode) {
                case 0x1000001: 
                case 0x1000002: {
                    return;
                }
                case 0x1000004: {
                    boolean result = this.resultDetailComposite.setFocus();
                    if (!result) {
                        event.doit = false;
                    }
                    return;
                }
                case 0x1000003: {
                    return;
                }
            }
            _spotlightShell.setFocusAppendChar(event.character);
        });
        this.tableSpotlightResults.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem item = SpotlightResultListComposite.this.tableSpotlightResults.getItem(new Point(e.x, e.y));
                if (item != null) {
                    SpotlightResultListComposite.this.tvSpotlightResults.setSelection((ISelection)new StructuredSelection(item.getData()), true);
                }
            }
        });
        this.tableSpotlightResults.addListener(16, event -> this.tvSpotlightResults.setSelection(null));
        this.tvSpotlightResults.addSelectionChangedListener(sel -> {
            Object firstElement = sel.getStructuredSelection().getFirstElement();
            if (firstElement instanceof ISpotlightResultEntry) {
                this.resultDetailComposite.setSelection((ISpotlightResultEntry)firstElement);
                ((SpotlightShell)this.getShell()).setSelectedElement(firstElement);
                uiUtil.handleDocumentSelectionAndPreview(firstElement, _spotlightShell);
            }
        });
        Consumer<ISpotlightResult> resultsChangedConsumer = newInput -> {
            if (!_spotlightShell.isDisposed()) {
                _spotlightShell.getDisplay().asyncExec(() -> {
                    if (!this.tableSpotlightResults.isDisposed()) {
                        this.tableSpotlightResults.clearAll();
                        this.tvSpotlightResults.setInput(newInput);
                    }
                });
            }
        };
        spotlightService.setResultsChangedConsumer(resultsChangedConsumer);
    }

    public boolean setFocus() {
        return this.tableSpotlightResults.setFocus();
    }

    protected void checkSubclass() {
    }

    void setDetailComposite(SpotlightResultDetailComposite resultDetailComposite) {
        this.resultDetailComposite = resultDetailComposite;
    }

    public boolean handleEnterOnFirstSpotlightResultEntry() {
        Object element = this.tvSpotlightResults.getElementAt(1);
        return this.uiUtil.handleEnter(element);
    }
}

