/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.controls.detail;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IEncounterService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.spotlight.ISpotlightResultEntry;
import ch.elexis.core.spotlight.ui.ISpotlightResultEntryDetailComposite;
import ch.elexis.core.spotlight.ui.controls.AbstractSpotlightResultEntryDetailComposite;
import ch.elexis.core.spotlight.ui.controls.SpotlightSearchHelper;
import ch.elexis.core.spotlight.ui.controls.detail.PatientDetailCompositeUtil;
import ch.elexis.core.spotlight.ui.internal.SpotlightShell;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PatientDetailComposite
extends AbstractSpotlightResultEntryDetailComposite
implements ISpotlightResultEntryDetailComposite {
    private static final String PATIENT_LABEL_FONT = "patient-label-font";
    @Inject
    private IStickerService stickerService;
    @Inject
    private IEncounterService encounterService;
    private IModelService coreModelService;
    private PatientDetailCompositeUtil util;
    private Label lblPatientlabel;
    private Composite stickerComposite;
    private StyledText styledText;
    private IPatient selectedPatient;
    private IAppointment selectedNextAppointment;
    private IAppointment selectedPreviousAppointment;
    private final String TEMPLATE = "Stammarzt\t{0}\r\nVersicherung\t{1}\r\nKonto\t{2}\t<m0>ALT+B</m>\r\n\r\n<lt>N\u00e4chster Termin</l>\t{3}\t<m0>ALT+T</m>\r\n<l0>Letzter Termin</l>\t{4}\r\n<ll>Letztes Labor</l>\t{5}\t<m0>ALT+L</m>\r\n\r\n<lk>Letzte Kons</l>\t{6}\t<m0>ALT+K</m>\r\n{7}\r\n\r\n<lf>Fixmedikation</l>\t\t<m0>ALT+F</m>\r\n{8}";
    private final Pattern TAG_PATTERN = Pattern.compile("<([a-z])([0a-z])>(.+?)</[a-z]>");

    public PatientDetailComposite(Composite parent, int style) {
        super(parent, style);
        Font patientLabelFont;
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        this.setLayout((Layout)gridLayout);
        this.util = new PatientDetailCompositeUtil();
        this.coreModelService = CoreModelServiceHolder.get();
        this.lblPatientlabel = new Label((Composite)this, 0);
        if (JFaceResources.getFontRegistry().hasValueFor(PATIENT_LABEL_FONT)) {
            patientLabelFont = JFaceResources.getFontRegistry().get(PATIENT_LABEL_FONT);
        } else {
            FontData[] fontData = this.lblPatientlabel.getFont().getFontData();
            fontData[0].setHeight(fontData[0].getHeight() + 1);
            JFaceResources.getFontRegistry().put(PATIENT_LABEL_FONT, fontData);
            patientLabelFont = JFaceResources.getFontRegistry().get(PATIENT_LABEL_FONT);
        }
        this.lblPatientlabel.setFont(patientLabelFont);
        this.lblPatientlabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.lblPatientlabel.setBackground(Display.getCurrent().getSystemColor(2));
        this.lblPatientlabel.setForeground(Display.getCurrent().getSystemColor(1));
        this.stickerComposite = new Composite((Composite)this, 0);
        FillLayout fl_stickerComposite = new FillLayout(256);
        fl_stickerComposite.spacing = 5;
        this.stickerComposite.setLayout((Layout)fl_stickerComposite);
        GridData gd_stickerComposite = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_stickerComposite.heightHint = 16;
        this.stickerComposite.setLayoutData((Object)gd_stickerComposite);
        this.styledText = new StyledText((Composite)this, 832);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.styledText.setEditable(false);
        this.styledText.setBackground(this.getBackground());
        this.styledText.setTabStops(new int[]{100, 350});
        this.styledText.setLineSpacingProvider(lineIndex -> 3);
        this.styledText.addListener(3, event -> {
            int offset = this.styledText.getOffsetAtPoint(new Point(event.x, event.y));
            if (offset != -1) {
                try {
                    StyleRange sr = this.styledText.getStyleRangeAtOffset(offset);
                    if (sr != null && sr.data instanceof String) {
                        String linkAction = (String)sr.data;
                        this.handleAltKeyPressed(linkAction.charAt(0));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        this.setSpotlightEntry(null);
    }

    @Override
    public boolean setFocus() {
        return this.styledText.setFocus();
    }

    protected void checkSubclass() {
    }

    @Override
    public void setSpotlightEntry(final ISpotlightResultEntry resultEntry) {
        this.selectedPatient = null;
        this.selectedNextAppointment = null;
        this.selectedPreviousAppointment = null;
        this.clearPopulatePatientLabelComposite(null);
        this.clearPopulateStickerComposite(null);
        this.updateStyledText(null);
        if (resultEntry != null) {
            this.lblPatientlabel.setText("Lade Datensatz ...");
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (resultEntry != null) {
                        Optional object = resultEntry.getObject();
                        if (!object.isPresent()) {
                            String patientId = resultEntry.getLoaderString();
                            PatientDetailComposite.this.selectedPatient = PatientDetailComposite.this.coreModelService.load(patientId, IPatient.class).orElse(null);
                        } else {
                            PatientDetailComposite.this.selectedPatient = (IPatient)object.get();
                        }
                    }
                    PatientDetailComposite.this.clearPopulatePatientLabelComposite(PatientDetailComposite.this.selectedPatient);
                    PatientDetailComposite.this.clearPopulateStickerComposite(PatientDetailComposite.this.selectedPatient);
                    PatientDetailComposite.this.updateStyledText(PatientDetailComposite.this.selectedPatient);
                    PatientDetailComposite.this.layout(true);
                }
            });
        }
    }

    private void updateStyledText(IPatient patient) {
        IEncounter _latestEncounter;
        this.styledText.setStyleRange(null);
        Object[] values = new Object[9];
        Arrays.fill(values, "-");
        values[0] = this.util.getFormattedFamilyDoctor(patient);
        values[1] = this.util.getFormattedInsurance(this.coreModelService, patient);
        values[2] = this.util.getFormattedPatientBalance(this.coreModelService, patient);
        this.selectedNextAppointment = this.util.getNextAppointment(this.coreModelService, patient);
        values[3] = this.util.getAppointmentLabel(this.selectedNextAppointment);
        this.selectedPreviousAppointment = this.util.getPreviousAppointment(this.coreModelService, patient);
        values[4] = this.util.getAppointmentLabel(this.selectedPreviousAppointment);
        values[5] = this.util.getFormattedLatestLaboratoryDate(this.coreModelService, patient);
        if (patient != null && (_latestEncounter = (IEncounter)this.encounterService.getLatestEncounter(patient).orElse(null)) != null) {
            values[6] = this.util.formatDate(_latestEncounter.getDate());
            String encounterText = _latestEncounter.getHeadVersionInPlaintext().trim().replaceAll("\n", " ");
            Object[] encounterValue = new String[4];
            int stepWidth = 65;
            encounterValue[0] = StringUtils.substring((String)encounterText, (int)0, (int)65);
            encounterValue[1] = StringUtils.substring((String)encounterText, (int)65, (int)130);
            encounterValue[2] = StringUtils.substring((String)encounterText, (int)130, (int)195);
            encounterValue[3] = StringUtils.substring((String)encounterText, (int)195, (int)260);
            values[7] = StringUtils.join((Object[])encounterValue, (String)"\n");
        }
        values[8] = this.util.getFormattedFixedMedication(this.coreModelService, patient);
        String text = MessageFormat.format("Stammarzt\t{0}\r\nVersicherung\t{1}\r\nKonto\t{2}\t<m0>ALT+B</m>\r\n\r\n<lt>N\u00e4chster Termin</l>\t{3}\t<m0>ALT+T</m>\r\n<l0>Letzter Termin</l>\t{4}\r\n<ll>Letztes Labor</l>\t{5}\t<m0>ALT+L</m>\r\n\r\n<lk>Letzte Kons</l>\t{6}\t<m0>ALT+K</m>\r\n{7}\r\n\r\n<lf>Fixmedikation</l>\t\t<m0>ALT+F</m>\r\n{8}", values);
        StyleRange[] styleRanges = this.generateStyleRanges(text);
        String replaceAll = text.replaceAll("<(.+?)>", "");
        this.styledText.setText(replaceAll);
        this.styledText.setStyleRanges(styleRanges);
        SpotlightShell shell = (SpotlightShell)this.getShell();
        String currentSearchText = shell.getSearchText();
        int count = SpotlightSearchHelper.highlightSearchText(this.styledText, currentSearchText);
        shell.setlableText(count);
    }

    private StyleRange[] generateStyleRanges(String text) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        int matchedFormatChars = 0;
        Matcher matcher = this.TAG_PATTERN.matcher(text);
        while (matcher.find()) {
            StyleRange sr = new StyleRange();
            String tag = matcher.group(1).intern();
            String keybindingCode = matcher.group(2).intern();
            sr.start = matcher.start() - matchedFormatChars;
            sr.length = matcher.group(3).length();
            switch (tag) {
                case "l": {
                    sr.underline = true;
                    sr.underlineStyle = 4;
                    sr.data = keybindingCode;
                    break;
                }
                case "m": {
                    sr.foreground = Display.getDefault().getSystemColor(15);
                    break;
                }
            }
            matchedFormatChars += 8;
            ranges.add(sr);
        }
        return ranges.toArray(new StyleRange[0]);
    }

    private void clearPopulateStickerComposite(IPatient patient) {
        this.util.clearComposite(this.stickerComposite, new Control[0]);
        if (patient != null) {
            List stickers = this.stickerService.getStickers((Identifiable)patient);
            for (ISticker sticker : stickers) {
                Label label = new Label(this.stickerComposite, 0);
                label.setForeground(CoreUiUtil.getColorForString((String)sticker.getForeground()));
                label.setBackground(CoreUiUtil.getColorForString((String)sticker.getBackground()));
                label.setText(sticker.getLabel());
            }
        }
        this.stickerComposite.layout();
    }

    private void clearPopulatePatientLabelComposite(IPatient patient) {
        if (patient == null) {
            this.lblPatientlabel.setText("");
        } else {
            this.lblPatientlabel.setText(patient.getLabel() + " (" + patient.getAgeInYears() + " Jahre)");
        }
    }

    @Override
    public ISpotlightResultEntry.Category appliedForCategory() {
        return ISpotlightResultEntry.Category.PATIENT;
    }

    @Override
    public boolean handleAltKeyPressed(int keyCode) {
        String selectedElement = null;
        if (this.selectedPatient != null) {
            switch (keyCode) {
                case 66: 
                case 98: {
                    selectedElement = "sb::" + this.selectedPatient.getId();
                    break;
                }
                case 84: 
                case 116: {
                    String id;
                    String string = id = this.selectedNextAppointment != null ? this.selectedNextAppointment.getId() : null;
                    if (id == null) break;
                    selectedElement = "sam::" + id;
                    break;
                }
                case 75: 
                case 107: {
                    selectedElement = "sle::" + this.selectedPatient.getId();
                    break;
                }
                case 76: 
                case 108: {
                    selectedElement = "sll::" + this.selectedPatient.getId();
                    break;
                }
                case 70: 
                case 102: {
                    selectedElement = "sfm::" + this.selectedPatient.getId();
                    break;
                }
            }
        }
        if (selectedElement != null) {
            SpotlightShell shell = (SpotlightShell)this.getShell();
            shell.setSelectedElement(selectedElement);
            return shell.handleSelectedElement();
        }
        return false;
    }
}

