/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.model.format.PatientFormatUtil;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.internal.text.TextPlaceholderContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PatientTextPlaceholderResolver
implements ITextPlaceholderResolver {
    @Reference(target="(type=Kontakt)")
    private ITextPlaceholderResolver contactTextPlaceholderResolver;

    public String getSupportedType() {
        return "Patient";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        ArrayList<PlaceholderAttribute> ret = new ArrayList<PlaceholderAttribute>();
        ret.addAll(Arrays.asList(PatientAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList()));
        if (this.contactTextPlaceholderResolver != null) {
            ret.addAll(this.contactTextPlaceholderResolver.getSupportedAttributes());
        }
        return ret;
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IPatient patient = this.getIdentifiable(context).orElse(null);
        if (patient != null) {
            return Optional.ofNullable(this.replace(patient, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        Optional ret = context.getTyped(IPatient.class);
        if (ret.isEmpty()) {
            ret = context.getNamed(this.getSupportedType());
        }
        return ret;
    }

    private String replace(IPatient patient, String lcAttribute) {
        IContact contact;
        TextPlaceholderContext context;
        Optional contactReplacement;
        PatientAttribute patientAttribut = (PatientAttribute)this.searchEnum(PatientAttribute.class, lcAttribute);
        if (patientAttribut != null) {
            switch (patientAttribut) {
                case Anrede: {
                    return PersonFormatUtil.getSalutation((IPerson)patient);
                }
                case Name: {
                    return patient.getLastName();
                }
                case Vorname: {
                    return patient.getFirstName();
                }
                case Geburtsdatum: {
                    return PersonFormatUtil.getDateOfBirth((IPerson)patient);
                }
                case Geschlecht: {
                    return Character.toString(PersonFormatUtil.getGenderCharLocalized((IPerson)patient));
                }
                case Diagnosen: {
                    return StringUtils.defaultString((String)patient.getDiagnosen());
                }
                case Allergien: {
                    return StringUtils.defaultString((String)patient.getAllergies());
                }
                case Risiken: {
                    return StringUtils.defaultString((String)patient.getRisk());
                }
                case PersAnamnese: {
                    return StringUtils.defaultString((String)patient.getPersonalAnamnese());
                }
                case FamilienAnamnese: {
                    return StringUtils.defaultString((String)patient.getFamilyAnamnese());
                }
                case Medikation: {
                    return PatientFormatUtil.getMedicationText((IPatient)patient, (EntryType)EntryType.FIXED_MEDICATION);
                }
                case SymptomatischeMedikation: {
                    return PatientFormatUtil.getMedicationText((IPatient)patient, (EntryType)EntryType.SYMPTOMATIC_MEDICATION);
                }
                case ReserveMedikation: {
                    return PatientFormatUtil.getMedicationText((IPatient)patient, (EntryType)EntryType.RESERVE_MEDICATION);
                }
                case AHV: {
                    IXid xid = patient.getXid("www.ahv.ch/xid");
                    if (xid != null) {
                        return xid.getDomainId();
                    }
                }
                case GesetzVertreter: {
                    IPatient guardian = patient.getLegalGuardian() != null ? patient.getLegalGuardian() : patient;
                    return AddressFormatUtil.getPostalAddress((IContact)guardian, (boolean)true);
                }
            }
        }
        if (this.contactTextPlaceholderResolver != null && (contactReplacement = this.contactTextPlaceholderResolver.replaceByTypeAndAttribute((IContext)(context = new TextPlaceholderContext((Identifiable)(contact = (IContact)CoreModelServiceHolder.get().load(patient.getId(), IContact.class).get()))), lcAttribute)).isPresent()) {
            return (String)contactReplacement.get();
        }
        return null;
    }

    private static enum PatientAttribute implements ILocalizedEnum
    {
        Name("Nachname des Patienten"),
        Vorname("Vorname des Patienten"),
        Anrede("Anrede des Patienten"),
        Geburtsdatum("Geburtsdatum des Patienten"),
        Geschlecht("Geschlecht des Patienten"),
        Diagnosen("Diagnosen des Patienten"),
        Allergien("Allergien des Patienten"),
        Risiken("Risiken des Patienten"),
        Medikation("Medikation des Patienten"),
        SymptomatischeMedikation("Symptomatische Medikation des Patienten"),
        ReserveMedikation("Reserve Medikation des Patienten"),
        PersAnamnese("Pers\u00f6nliche Anamnese des Patienten"),
        FamilienAnamnese("Familien Anamnese des Patienten"),
        AHV("AHV Nummer des Patienten"),
        GesetzVertreter("Gesetzlicher Vertreter des Patienten");

        final String description;

        private PatientAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

