/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.internal.text.TextPlaceholderContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class MandantTextPlaceholderResolver
implements ITextPlaceholderResolver {
    @Reference(target="(type=Kontakt)")
    private ITextPlaceholderResolver contactTextPlaceholderResolver;

    public String getSupportedType() {
        return "Mandant";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        ArrayList<PlaceholderAttribute> ret = new ArrayList<PlaceholderAttribute>();
        ret.addAll(Arrays.asList(MandantAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList()));
        if (this.contactTextPlaceholderResolver != null) {
            ret.addAll(this.contactTextPlaceholderResolver.getSupportedAttributes());
        }
        return ret;
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        IMandator mandantor = this.getIdentifiable(context).orElse(null);
        if (mandantor != null) {
            return Optional.ofNullable(this.replace(mandantor, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        Optional ret = context.getTyped(IMandator.class);
        if (ret.isEmpty()) {
            ret = context.getNamed(this.getSupportedType());
        }
        return ret;
    }

    private String replace(IMandator mandator, String lcAttribute) {
        IContact contact;
        TextPlaceholderContext context;
        Optional contactReplacement;
        MandantAttribute mandantAttribut = (MandantAttribute)this.searchEnum(MandantAttribute.class, lcAttribute);
        if (mandantAttribut != null) {
            switch (mandantAttribut) {
                case Anrede: {
                    if (mandator.isPerson()) {
                        return PersonFormatUtil.getSalutation((IPerson)((IPerson)CoreModelServiceHolder.get().load(mandator.getId(), IPerson.class).get()));
                    }
                    return "";
                }
                case Name: {
                    return mandator.getDescription1();
                }
                case Vorname: {
                    return mandator.getDescription2();
                }
                case Titel: {
                    if (mandator.isPerson()) {
                        return ((IPerson)CoreModelServiceHolder.get().load(mandator.getId(), IPerson.class).get()).getTitel();
                    }
                }
                case TarmedSpezialit\u00e4t: {
                    return (String)mandator.getExtInfo((Object)"TarmedSpezialit\u00e4t");
                }
                case EAN: {
                    IXid xid = mandator.getXid("www.xid.ch/id/ean");
                    if (xid != null) {
                        return xid.getDomainId();
                    }
                }
                case KSK: {
                    IXid xid = mandator.getXid("www.xid.ch/id/ksk");
                    if (xid != null) {
                        return xid.getDomainId();
                    }
                }
                case Spezialit\u00e4t: {
                    return (String)mandator.getExtInfo((Object)"Spezialit\u00e4t");
                }
            }
        }
        if (this.contactTextPlaceholderResolver != null && (contactReplacement = this.contactTextPlaceholderResolver.replaceByTypeAndAttribute((IContext)(context = new TextPlaceholderContext((Identifiable)(contact = (IContact)CoreModelServiceHolder.get().load(mandator.getId(), IContact.class).get()))), lcAttribute)).isPresent()) {
            return (String)contactReplacement.get();
        }
        return null;
    }

    private static enum MandantAttribute implements ILocalizedEnum
    {
        Name("Nachname des Mandanten"),
        Vorname("Vorname des Mandanten"),
        Titel("Titel des Mandanten"),
        Anrede("Anrede des Mandanten"),
        TarmedSpezialit\u00e4t("Tarmed Spezialit\u00e4t des Mandanten"),
        EAN("EAN des Mandanten"),
        KSK("KSK des Mandanten"),
        Spezialit\u00e4t("Spezialit\u00e4t des Mandanten");

        final String description;

        private MandantAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

