/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.PostalAddress;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CoverageTextPlaceholderResolver
implements ITextPlaceholderResolver {
    @Reference
    private ICoverageService coverageService;

    public String getSupportedType() {
        return "Fall";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(FallAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        ICoverage coverage = this.getIdentifiable(context).orElse(null);
        if (coverage != null) {
            return Optional.ofNullable(this.replace(coverage, attribute.toLowerCase()));
        }
        return Optional.empty();
    }

    public Optional<? extends Identifiable> getIdentifiable(IContext context) {
        Optional ret = context.getTyped(ICoverage.class);
        if (ret.isEmpty()) {
            ret = context.getNamed(this.getSupportedType());
        }
        return ret;
    }

    private String replace(ICoverage coverage, String lcAttribute) {
        FallAttribute attribute = (FallAttribute)this.searchEnum(FallAttribute.class, lcAttribute);
        IContact contact = null;
        switch (attribute) {
            case Versicherungsnummer: {
                return coverage.getInsuranceNumber();
            }
            case Kostentraeger: {
                return coverage.getCostBearer() != null ? coverage.getCostBearer().getPostalAddress() : "";
            }
            case KostentraegerKuerzel: {
                String label;
                if (coverage.getCostBearer() != null && (label = coverage.getCostBearer().getLabel()).lastIndexOf(",") > 0) {
                    String fullName = label.substring(0, label.indexOf(","));
                    return fullName;
                }
                return "";
            }
            case KostentraegerOrt: {
                if (coverage.getCostBearer() != null) {
                    return PostalAddress.of((IContact)coverage.getCostBearer()).getCity();
                }
                return "";
            }
            case Arbeitgeber: {
                contact = this.coverageService.getRequiredContact(coverage, "Arbeitgeber");
                if (contact != null) {
                    return contact.getPostalAddress();
                }
                return "";
            }
            case ArbeitgeberKuerzel: {
                String label;
                contact = this.coverageService.getRequiredContact(coverage, "Arbeitgeber");
                if (contact != null && (label = contact.getLabel()).lastIndexOf(",") > 0) {
                    String fullName = label.substring(0, label.indexOf(","));
                    return fullName;
                }
                return "";
            }
            case Zuweiser: {
                contact = this.coverageService.getRequiredContact(coverage, "Zuweiser");
                if (contact != null) {
                    return contact.getPostalAddress();
                }
                return "";
            }
            case ZuweiserKuerzel: {
                String label;
                contact = this.coverageService.getRequiredContact(coverage, "Zuweiser");
                if (contact != null && (label = contact.getLabel()).lastIndexOf(",") > 0) {
                    String fullName = label.substring(0, label.indexOf(","));
                    return fullName;
                }
                return "";
            }
        }
        return null;
    }

    private static enum FallAttribute implements ILocalizedEnum
    {
        Versicherungsnummer("Versicherungsnummer des Fall"),
        Kostentraeger("Kostentr\u00e4ger des Fall"),
        KostentraegerKuerzel("K\u00fcrzel des Kostentr\u00e4ger des Fall"),
        KostentraegerOrt("Ort des Kostentr\u00e4ger des Fall"),
        Arbeitgeber("Arbeitgeber des Fall"),
        ArbeitgeberKuerzel("K\u00fcrzel des Arbeitgeber des Fall"),
        Zuweiser("Zuweiser des Fall"),
        ZuweiserKuerzel("K\u00fcrzel des Zuweiser des Fall");

        final String description;

        private FallAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

