/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.CoreUtil;
import ch.rgw.tools.TimeTool;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class InitializeDatabaseService {
    private static final String ADMINISTRATOR = "Administrator";
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private IConfigService configService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    @Activate
    public void activate() {
        this.accessControlService.doPrivileged(() -> {
            if (this.needsInitialization()) {
                LoggerFactory.getLogger(this.getClass()).info("Initializing Database");
                this.initAdministrator();
                this.writeCreated();
            }
            this.autoCreateFirstMandator(this.isRunningFromScratch() || CoreUtil.isTestMode());
        });
    }

    private IMandator autoCreateFirstMandator(boolean fromScratch) {
        if (fromScratch) {
            String clientEmail = System.getProperty("ch.elexis.clientEmail");
            if (clientEmail == null) {
                clientEmail = "james@bond.invalid";
            }
            IMandator ret = this.createMandatorWithUser("007", "topsecret", "James", "Bond", clientEmail);
            IPerson person = ret.asIPerson();
            person.setTitel("Dr. med.");
            person.setGender(Gender.MALE);
            person.setPhone1("0061 555 55 55");
            person.setFax("0061 555 55 56");
            person.setStreet("10, Baker Street");
            person.setZip("9999");
            person.setCity("Elexikon");
            this.coreModelService.save((Identifiable)person);
            return ret;
        }
        String firstMandantName = System.getProperty("ch.elexis.firstMandantName", "");
        String firstMandantEmail = System.getProperty("ch.elexis.firstMandantEmail", "");
        String firstMandantPassword = System.getProperty("ch.elexis.firstMandantPassword", "");
        if (firstMandantEmail.contains("@") && !firstMandantName.isEmpty() && !firstMandantPassword.isEmpty()) {
            IMandator ret = this.createMandatorWithUser(firstMandantName, firstMandantPassword, firstMandantName, firstMandantName, firstMandantEmail);
            return ret;
        }
        return null;
    }

    private IMandator createMandatorWithUser(String username, String password, String firstName, String lastName, String email) {
        IMandator mandator = (IMandator)new IContactBuilder.MandatorBuilder(this.coreModelService, firstName, lastName).build();
        mandator.setUser(true);
        mandator.setActive(true);
        mandator.setPerson(true);
        mandator.setEmail(email);
        this.coreModelService.save((Identifiable)mandator);
        IUser user = (IUser)new IUserBuilder(this.coreModelService, username, (IContact)mandator).build();
        this.coreModelService.load("medical-user", IRole.class).ifPresent(arg_0 -> ((IUser)user).addRole(arg_0));
        this.coreModelService.load("medical-practitioner", IRole.class).ifPresent(arg_0 -> ((IUser)user).addRole(arg_0));
        this.coreModelService.save((Identifiable)user);
        return mandator;
    }

    private void initAdministrator() {
        Optional user;
        IPerson person = this.coreModelService.getQuery(IPerson.class).and((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.COMPARATOR.EQUALS, (Object)ADMINISTRATOR).executeSingleResult().orElse(null);
        if (person == null) {
            person = (IPerson)new IContactBuilder.PersonBuilder(this.coreModelService, ADMINISTRATOR, ADMINISTRATOR, Gender.UNKNOWN).build();
            person.setUser(true);
            this.coreModelService.save((Identifiable)person);
        }
        if (!(user = this.coreModelService.load(ADMINISTRATOR, IUser.class)).isPresent() || ((IUser)user.get()).getAssignedContact() != null) {
            throw new IllegalStateException("Incorrect DB state - No admin user found!");
        }
        ((IUser)user.get()).setAssignedContact((IContact)person);
        ((IUser)user.get()).removeRole((IRole)this.coreModelService.load("medical-user", IRole.class).get());
        this.coreModelService.save((Identifiable)user.get());
    }

    private void writeCreated() {
        this.configService.set("created", new TimeTool().toString(0));
    }

    private boolean needsInitialization() {
        return this.configService.get("created", null) == null;
    }

    private boolean isRunningFromScratch() {
        return "RunFromScratch".equals(System.getProperty("elexis-run-mode"));
    }
}

