/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.stock.ICommissioningSystemDriver;
import ch.elexis.core.services.IElexisServerService;
import ch.elexis.core.services.IStockCommissioningSystemService;
import ch.elexis.core.services.StockCommissioningSystemDriverFactories;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class StockCommissioningSystemService
implements IStockCommissioningSystemService {
    @Reference
    private IElexisServerService elexisServerService;

    public List<UUID> listAllAvailableDrivers() {
        return StockCommissioningSystemDriverFactories.getAllDriverUuids();
    }

    public String getInfoStringForDriver(UUID driverUuid, boolean extended) {
        return StockCommissioningSystemDriverFactories.getInfoStringForDriver(driverUuid, extended);
    }

    public IStatus initializeStockCommissioningSystem(IStock stock) {
        return Status.OK_STATUS;
    }

    public IStatus performArticleOutlay(IStockEntry stockEntry, int quantity, Map<String, Object> data) {
        if (stockEntry == null) {
            return new Status(4, "ch.elexis.core.services", "stock entry is null");
        }
        ElexisEvent performOutlayEvent = new ElexisEvent();
        performOutlayEvent.setTopic("info/elexis/stockCommissioning/outlay");
        performOutlayEvent.getProperties().put("stockEntryId", stockEntry.getId());
        performOutlayEvent.getProperties().put("quantity", Integer.toString(quantity));
        return this.elexisServerService.postEvent(performOutlayEvent);
    }

    public ICommissioningSystemDriver getDriverInstanceForStock(IStock stock) {
        return null;
    }

    public IStatus synchronizeInventory(IStock stock, List<String> articleIds, Map<String, Object> data) {
        ElexisEvent synchronizeEvent = new ElexisEvent();
        synchronizeEvent.setTopic("info/elexis/stockCommissioning/updateStock");
        synchronizeEvent.getProperties().put("stockId", stock.getId());
        return this.elexisServerService.postEvent(synchronizeEvent);
    }

    public IStatus initializeInstancesUsingDriver(UUID driver) {
        return Status.OK_STATUS;
    }

    public IStatus shutdownInstancesUsingDriver(UUID driver) {
        return Status.OK_STATUS;
    }

    public IStatus shutdownStockCommissioningSytem(IStock stock) {
        return Status.OK_STATUS;
    }
}

