/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderHistoryService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.OrderHistoryService;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class OrderService
implements IOrderService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;

    public IOrderHistoryService getHistoryService() {
        return new OrderHistoryService();
    }

    public IOrderEntry findOpenOrderEntryForStockEntry(IStockEntry stockEntry) {
        IArticle article = stockEntry.getArticle();
        if (article != null) {
            String[] parts = StoreToStringServiceHolder.getStoreToString(article).split("::");
            IQuery query = this.modelService.getQuery(IOrderEntry.class);
            query.and("stockid", IQuery.COMPARATOR.EQUALS, (Object)stockEntry.getStock().getId());
            query.and("articleType", IQuery.COMPARATOR.EQUALS, (Object)parts[0]);
            query.and("articleId", IQuery.COMPARATOR.EQUALS, (Object)parts[1]);
            query.and("state", IQuery.COMPARATOR.NOT_EQUALS, (Object)OrderEntryState.DONE.getValue());
            List results = query.execute();
            if (!results.isEmpty()) {
                return (IOrderEntry)results.get(0);
            }
        }
        return null;
    }

    public List<IOrderEntry> findOrderEntryForStock(IStock stock) {
        IQuery query = this.modelService.getQuery(IOrderEntry.class);
        query.and("stockid", IQuery.COMPARATOR.EQUALS, (Object)stock.getId());
        return query.execute();
    }

    public IOrderEntry addRefillForStockEntryToOrder(IStockEntry ise, IOrder order) {
        int toOrder;
        int current = ise.getCurrentStock();
        int max = ise.getMaximumStock();
        if (max == 0) {
            max = ise.getMinimumStock();
        }
        if ((toOrder = max - current) > 0) {
            IOrderEntry entry = order.addEntry(ise.getArticle(), ise.getStock(), ise.getProvider(), toOrder);
            this.modelService.save((Identifiable)entry);
            this.getHistoryService().logChangedAmount(order, entry, 0, toOrder);
            return entry;
        }
        return null;
    }

    public Map<IArticle, Integer> calculateDailyConsumption(LocalDate date, List<IMandator> mandators) {
        LinkedHashMap<IArticle, Integer> result = new LinkedHashMap<IArticle, Integer>();
        IQuery query = this.modelService.getQuery(IEncounter.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__DATE, IQuery.COMPARATOR.EQUALS, (Object)date);
        if (mandators != null && !mandators.isEmpty()) {
            query.startGroup();
            for (IMandator m : mandators) {
                query.or((EStructuralFeature)ModelPackage.Literals.IENCOUNTER__MANDATOR, IQuery.COMPARATOR.EQUALS, (Object)m);
            }
            query.andJoinGroups();
        }
        for (IEncounter encounter : query.execute()) {
            for (IBilled billed : encounter.getBilled()) {
                IBillable billable = billed.getBillable();
                if (!(billable instanceof IArticle)) continue;
                IArticle art = (IArticle)billable;
                int amount = (int)billed.getAmount();
                result.merge(art, amount, Integer::sum);
            }
        }
        return result;
    }

    public void reduceOpenEntries(List<IOrder> orders, IArticle article, int reduceBy) {
        for (IOrder order : orders) {
            List openEntries = order.getEntries().stream().filter(e -> e.getArticle().equals(article)).filter(e -> e.getState() == OrderEntryState.OPEN).collect(Collectors.toList());
            for (IOrderEntry entry : openEntries) {
                if (reduceBy <= 0) {
                    return;
                }
                int amount = entry.getAmount();
                if (amount <= reduceBy) {
                    reduceBy -= amount;
                    this.getHistoryService().logRemove(order, entry);
                    this.modelService.delete((Deleteable)entry);
                    continue;
                }
                entry.setAmount(amount - reduceBy);
                this.modelService.save((Identifiable)entry);
                this.getHistoryService().logChangedAmount(order, entry, amount, entry.getAmount());
                reduceBy = 0;
            }
        }
    }

    public void addOrCreateOrderEntries(List<IOrder> existingOrders, IOrder createOrder, Map<IArticle, Integer> entriesToAdd, @Nullable IMandator mandator) {
        this.getHistoryService().logCreateOrder(createOrder);
        for (Map.Entry<IArticle, Integer> entry : entriesToAdd.entrySet()) {
            if (entry.getValue() <= 0) continue;
            IArticle article = entry.getKey();
            int amountToAdd = entry.getValue();
            boolean appended = false;
            for (IOrder order : existingOrders) {
                for (IOrderEntry oe : order.getEntries()) {
                    if (!oe.getArticle().equals(article) || oe.getState() != OrderEntryState.OPEN) continue;
                    int old = oe.getAmount();
                    oe.setAmount(old + amountToAdd);
                    this.modelService.save((Identifiable)oe);
                    this.getHistoryService().logChangedAmount(order, oe, old, oe.getAmount());
                    appended = true;
                    break;
                }
                if (appended) break;
            }
            if (appended) continue;
            IStockEntry se = null;
            if (mandator != null) {
                String articleStr = StoreToStringServiceHolder.getStoreToString(article);
                se = StockServiceHolder.get().findPreferredStockEntryForArticle(articleStr, mandator.getId());
            }
            IOrderEntry newEntry = se != null ? createOrder.addEntry(se.getArticle(), se.getStock(), se.getProvider(), amountToAdd) : createOrder.addEntry(article, null, null, amountToAdd);
            this.modelService.save((Identifiable)newEntry);
            this.getHistoryService().logChangedAmount(createOrder, newEntry, 0, amountToAdd);
        }
        if (!createOrder.getEntries().isEmpty()) {
            this.modelService.save((Identifiable)createOrder);
            this.modelService.refresh((Identifiable)createOrder, true);
        }
    }

    public List<IOrder> findOpenOrdersByDate(LocalDate date) {
        long startMillis = date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long endMillis = date.plusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - 1L;
        IQuery entryQuery = this.modelService.getQuery(IOrderEntry.class);
        entryQuery.and((EStructuralFeature)ModelPackage.Literals.IORDER_ENTRY__STATE, IQuery.COMPARATOR.IN, List.of(Integer.valueOf(OrderEntryState.OPEN.ordinal()), Integer.valueOf(OrderEntryState.ORDERED.ordinal())));
        entryQuery.and("lastupdate", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)startMillis);
        entryQuery.and("lastupdate", IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)endMillis);
        List matchingEntries = entryQuery.execute();
        return matchingEntries.stream().map(IOrderEntry::getOrder).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public Map<IArticle, Integer> calculateDailyDifferences(LocalDate date, List<IMandator> mandators) {
        Map<IArticle, Integer> consumptionMap = this.calculateDailyConsumption(date, mandators);
        List<IOrder> relevantOrders = this.findOpenOrdersByDate(date);
        HashMap<IArticle, Integer> orderedArticles = new HashMap<IArticle, Integer>();
        for (IOrder order : relevantOrders) {
            for (IOrderEntry entry : order.getEntries()) {
                if (entry.getState() != OrderEntryState.OPEN && entry.getState() != OrderEntryState.ORDERED) continue;
                orderedArticles.merge(entry.getArticle(), entry.getAmount(), Integer::sum);
            }
        }
        LinkedHashMap<IArticle, Integer> differences = new LinkedHashMap<IArticle, Integer>();
        for (Map.Entry<IArticle, Integer> entry : consumptionMap.entrySet()) {
            int alreadyOrdered = orderedArticles.getOrDefault(entry.getKey(), 0);
            int diff = entry.getValue() - alreadyOrdered;
            differences.put(entry.getKey(), diff);
        }
        return differences;
    }

    public boolean containsSupplier(IOrder order, IContact supplier) {
        if (order == null || supplier == null) {
            return false;
        }
        String supplierId = supplier.getId();
        for (IOrderEntry entry : order.getEntries()) {
            IContact provider = entry.getProvider();
            if (provider == null || !supplierId.equals(provider.getId())) continue;
            return true;
        }
        return false;
    }
}

