/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.IMessageService;
import ch.elexis.core.services.IMessageTransporter;
import ch.elexis.core.status.ObjectStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class MessageService
implements IMessageService {
    private Map<String, IMessageTransporter> messageTransporters = new HashMap<String, IMessageTransporter>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setMessageTransporter(IMessageTransporter messageTransporter) {
        if (!this.messageTransporters.containsKey(messageTransporter.getUriScheme())) {
            this.messageTransporters.put(messageTransporter.getUriScheme(), messageTransporter);
        }
    }

    public void unsetMessageTransporter(IMessageTransporter messageTransporter) {
        if (this.messageTransporters.containsKey(messageTransporter.getUriScheme())) {
            this.messageTransporters.remove(messageTransporter.getUriScheme());
        }
    }

    public TransientMessage prepare(String sender, String receiver) {
        return new TransientMessage(sender, receiver);
    }

    public List<String> getSupportedUriSchemes() {
        return new ArrayList<String>(this.messageTransporters.keySet());
    }

    public ObjectStatus<String> send(TransientMessage message) {
        String transporterScheme = message.getTransporterScheme();
        IMessageTransporter messageTransporter = null;
        messageTransporter = "internal".equals(transporterScheme) ? this.selectInternalSchemeTransporter() : this.messageTransporters.get(transporterScheme);
        if (messageTransporter == null) {
            return new ObjectStatus(4, "ch.elexis.core.services", "No transporter found for uri scheme [" + transporterScheme + "]", null);
        }
        if (messageTransporter.isExternal() && !message.isAlllowExternal()) {
            return new ObjectStatus(4, "ch.elexis.core.services", "Selected transporter is external, but message not marked as allowExternal, rejecting send.", null);
        }
        return new ObjectStatus(messageTransporter.send(message), (Object)messageTransporter.getUriScheme());
    }

    private IMessageTransporter selectInternalSchemeTransporter() {
        IMessageTransporter messageTransporter = this.messageTransporters.get("matrix");
        if (messageTransporter == null) {
            messageTransporter = this.messageTransporters.get("internaldb");
        }
        return messageTransporter;
    }
}

