/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IInvoiceBilled;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPayment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IAccountTransactionBuilder;
import ch.elexis.core.model.builder.IInvoiceBilledBuilder;
import ch.elexis.core.model.builder.IPaymentBuilder;
import ch.elexis.core.services.IInvoiceService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class InvoiceService
implements IInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceService.class);

    public Result<IInvoice> invoice(List<IEncounter> encounters) {
        Result result = new Result();
        int origSize = encounters.size();
        if ((encounters = encounters.stream().filter(e -> e.isBillable()).collect(Collectors.toList())).size() < origSize) {
            LoggerFactory.getLogger(this.getClass()).warn("Ignoring [" + (origSize - encounters.size()) + "] not billable encounters.");
        }
        if (encounters == null || encounters.isEmpty()) {
            return result.add(Result.SEVERITY.WARNING, 1, "Die Rechnung enth\u00e4lt keine Behandlungen (Konsultationen)", null, true);
        }
        for (IEncounter iEncounter : encounters) {
            IPatient patient = iEncounter.getCoverage().getPatient();
            if (patient.isPerson()) continue;
            logger.warn("Patient [" + patient.getPatientNr() + "] is person was not set. Setting is person automatically.");
            patient.setPerson(true);
            CoreModelServiceHolder.get().save((Identifiable)patient);
        }
        for (IEncounter iEncounter : encounters) {
            if (iEncounter.getBilled().isEmpty() || EncounterServiceHolder.get().getSales(iEncounter).isZero()) {
                LoggerFactory.getLogger(this.getClass()).warn("Ignoring encounter [" + iEncounter.getLabel() + "] with sales amount zero.");
                continue;
            }
            List encounterBilled = iEncounter.getBilled();
            for (IBilled billed : encounterBilled) {
                if (!billed.getPrice().isZero() || !this.isBillingCheckZero()) continue;
                IPatient pat = iEncounter.getCoverage().getPatient();
                String msg2 = "Die Konsultation vom " + iEncounter.getDate().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " f\u00fcr\nPatient Nr. " + pat.getPatientNr() + ", " + pat.getLastName() + ", " + pat.getFirstName() + ", " + pat.getDateOfBirth().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + "\nenth\u00e4lt mindestens eine Leistung zum Preis 0.00.\n\nDie \u00c4rztekasse w\u00fcrde so eine Rechnung zur\u00fcckgeben.\n\n";
                return result.add(Result.SEVERITY.WARNING, 1, msg2 + "Diese Rechnung wird jetzt nicht erstellt.\n\nBitte pr\u00fcfen Sie die verrechneten Leistungen,oder verschieben Sie die Konsultation zu einem sp\u00e4ter zu verrechnenden Fall!", null, true);
            }
        }
        IInvoice iInvoice = (IInvoice)CoreModelServiceHolder.get().create(IInvoice.class);
        LocalDate startDate = LocalDate.of(2999, 12, 31);
        LocalDate endDate = LocalDate.of(2000, 1, 1);
        LocalDate actDate = LocalDate.now();
        IMandator mandator = null;
        List encounterDiagnosis = null;
        ICoverage coverage = null;
        Money sum = new Money();
        for (IEncounter iEncounter : encounters) {
            IInvoice shouldntExist = iEncounter.getInvoice();
            if (shouldntExist != null && shouldntExist.getState() != InvoiceState.CANCELLED) {
                logger.warn("Tried to create bill for already billed kons " + iEncounter.getLabel());
                continue;
            }
            IMandator encounterMandator = iEncounter.getMandator();
            if (encounterMandator == null) {
                result = result.add(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiger Mandant bei Konsultation " + iEncounter.getLabel(), (Object)iInvoice, true);
                continue;
            }
            if (mandator == null) {
                mandator = encounterMandator;
                iInvoice.setMandator(mandator);
            } else if (!encounterMandator.getBiller().getId().equals(mandator.getBiller().getId())) {
                result = result.add(Result.SEVERITY.ERROR, 2, "Die Liste enth\u00e4lt unterschiedliche Rechnungssteller " + iEncounter.getLabel(), (Object)iInvoice, true);
                continue;
            }
            ICoverage encounterCoverage = iEncounter.getCoverage();
            if (encounterCoverage == null) {
                result = result.add(Result.SEVERITY.ERROR, 3, "Fehlender Fall bei Konsultation " + iEncounter.getLabel(), (Object)iInvoice, true);
                continue;
            }
            if (coverage == null) {
                coverage = encounterCoverage;
                iInvoice.setCoverage(coverage);
                coverage.setBillingProposalDate(null);
            } else if (!coverage.getId().equals(encounterCoverage.getId())) {
                result = result.add(Result.SEVERITY.ERROR, 4, "Die Liste enth\u00e4lt unterschiedliche Faelle " + iEncounter.getLabel(), (Object)iInvoice, true);
                continue;
            }
            if (encounterDiagnosis == null || encounterDiagnosis.isEmpty()) {
                encounterDiagnosis = iEncounter.getDiagnoses();
            }
            if (iEncounter.getDate() == null) {
                result = result.add(Result.SEVERITY.ERROR, 5, "Ung\u00fcltiges Datum bei Konsultation " + iEncounter.getLabel(), (Object)iInvoice, true);
                continue;
            }
            if ((actDate = actDate.with(iEncounter.getDate())).isBefore(startDate)) {
                startDate = startDate.with(actDate);
            }
            if (actDate.isAfter(endDate)) {
                endDate = endDate.with(actDate);
            }
            sum.addMoney(EncounterServiceHolder.get().getSales(iEncounter));
        }
        if (coverage == null) {
            result = result.add(Result.SEVERITY.ERROR, 8, "Die Rechnung ist keinem Fall zugeordnet (" + InvoiceService.getInvoiceDesc(iInvoice) + ")", (Object)iInvoice, true);
        } else if (this.isBillingStrict() && !CoverageServiceHolder.get().isValid(coverage)) {
            result = result.add(Result.SEVERITY.ERROR, 8, "Die Rechnung hat keinen g\u00fcltigen Fall (" + InvoiceService.getInvoiceDesc(iInvoice) + ")", (Object)iInvoice, true);
        }
        if (this.isBillingStrict() && (encounterDiagnosis == null || encounterDiagnosis.isEmpty())) {
            result = result.add(Result.SEVERITY.ERROR, 6, "Die Rechnung enth\u00e4lt keine Diagnose (" + InvoiceService.getInvoiceDesc(iInvoice) + ")", (Object)iInvoice, true);
        }
        iInvoice.setDateFrom(startDate);
        iInvoice.setDateTo(endDate);
        iInvoice.setDate(LocalDate.now());
        iInvoice.setState(InvoiceState.OPEN);
        iInvoice.setStateDate(LocalDate.now());
        iInvoice.setTotalAmount(sum);
        if (!result.isOK()) {
            return result;
        }
        CoreModelServiceHolder.get().save((Identifiable)iInvoice);
        ArrayList<IInvoiceBilled> arrayList = new ArrayList<IInvoiceBilled>();
        for (IEncounter iEncounter : encounters) {
            iEncounter.setInvoice(iInvoice);
            CoreModelServiceHolder.get().save((Identifiable)iEncounter);
            List encounterBilled = iEncounter.getBilled();
            for (IBilled billed : encounterBilled) {
                IInvoiceBilled invoiceBilled = (IInvoiceBilled)new IInvoiceBilledBuilder(CoreModelServiceHolder.get(), iInvoice, billed).build();
                arrayList.add(invoiceBilled);
            }
        }
        CoreModelServiceHolder.get().save(arrayList);
        if (iInvoice.getOpenAmount().isZero()) {
            iInvoice.setState(InvoiceState.PAID);
            CoreModelServiceHolder.get().save((Identifiable)iInvoice);
        } else if (coverage != null) {
            IAccountTransaction iAccountTransaction = (IAccountTransaction)new IAccountTransactionBuilder(CoreModelServiceHolder.get(), iInvoice, coverage.getPatient(), sum.negate(), iInvoice.getDate(), "Rn " + iInvoice.getNumber() + " erstellt.").buildAndSave();
        }
        return result.add(Result.SEVERITY.OK, 0, "Ok", (Object)iInvoice, false);
    }

    private boolean isBillingCheckZero() {
        Optional userContact = ContextServiceHolder.get().getActiveUserContact();
        if (userContact.isPresent()) {
            return ConfigServiceHolder.get().get((IContact)userContact.get(), "billing/zero_check", false);
        }
        return false;
    }

    private boolean isBillingStrict() {
        Optional userContact = ContextServiceHolder.get().getActiveUserContact();
        if (userContact.isPresent()) {
            return ConfigServiceHolder.get().get((IContact)userContact.get(), "billing/strict", true);
        }
        return true;
    }

    private static String getInvoiceDesc(IInvoice invoice) {
        StringBuilder sb = new StringBuilder();
        if (invoice == null) {
            sb.append("Keine Rechnungsnummer");
        } else {
            ICoverage coverage = invoice.getCoverage();
            sb.append("Rechnung: " + invoice.getNumber()).append(" / ");
            if (coverage == null) {
                sb.append("Kein Fall");
            } else {
                sb.append("Fall: " + coverage.getLabel()).append(" / ");
                IPatient pat = coverage.getPatient();
                if (pat == null) {
                    sb.append("Kein Patient");
                } else {
                    sb.append(pat.getLabel());
                }
            }
        }
        return sb.toString();
    }

    public List<IEncounter> cancel(IInvoice invoice, boolean reopen) {
        InvoiceState invoiceState = invoice.getState();
        List<IEncounter> ret = Collections.emptyList();
        if (!InvoiceState.CANCELLED.equals((Object)invoiceState) && !InvoiceState.DEPRECIATED.equals((Object)invoiceState)) {
            Money amount = invoice.getTotalAmount();
            Money demandAmount = invoice.getDemandAmount();
            if (!demandAmount.isZero()) {
                amount.addMoney(demandAmount);
            }
            this.addPayment(invoice, amount, "Storno", false);
            if (reopen) {
                ret = this.removeEncounters(invoice);
                invoice.setState(InvoiceState.CANCELLED);
                CoreModelServiceHolder.get().save((Identifiable)invoice);
            } else {
                invoice.setState(InvoiceState.DEPRECIATED);
                CoreModelServiceHolder.get().save((Identifiable)invoice);
            }
        } else if (reopen && InvoiceState.CANCELLED.equals((Object)invoiceState)) {
            ret = this.removeEncounters(invoice);
        }
        return ret;
    }

    private List<IEncounter> removeEncounters(IInvoice invoice) {
        List encounters = invoice.getEncounters();
        for (IEncounter iEncounter : encounters) {
            iEncounter.setInvoice(null);
        }
        CoreModelServiceHolder.get().save(encounters);
        return encounters;
    }

    public Optional<IInvoice> getInvoiceWithNumber(String number) {
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IInvoice.class, new String[]{"number"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"number", number}));
        if (!found.isEmpty()) {
            if (found.size() > 1) {
                logger.warn("Found " + found.size() + " invoices with number " + number + " using first");
            }
            return Optional.of((IInvoice)found.get(0));
        }
        return Optional.empty();
    }

    public List<IInvoice> getInvoices(IEncounter encounter) {
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IInvoiceBilled.class, new String[]{"encounter"});
        List invoicebilled = query.executeWithParameters(query.getParameterMap(new Object[]{"encounter", encounter}));
        HashSet uniqueInvoices = new HashSet();
        invoicebilled.stream().filter(ib -> ib.getInvoice() != null).forEach(ib -> {
            boolean bl = uniqueInvoices.add(ib.getInvoice());
        });
        return new ArrayList<IInvoice>(uniqueInvoices);
    }

    public boolean hasStornoBeforeDate(IInvoice invoice, LocalDate date) {
        List zahlungen = invoice.getPayments();
        for (IPayment zahlung : zahlungen) {
            if (!zahlung.getRemark().equals("Storno") || !zahlung.getDate().isBefore(date) && !zahlung.getDate().equals(date)) continue;
            return true;
        }
        return false;
    }

    public String getCombinedId(IInvoice invoice) {
        IPatient patient = invoice.getCoverage().getPatient();
        String pid = ConfigServiceHolder.get().get("PatIDMode", "number").equals("number") ? StringUtils.leftPad((String)patient.getCode(), (int)6, (char)'0') : new TimeTool(patient.getDateOfBirth()).toString(9);
        String nr = StringUtils.leftPad((String)invoice.getNumber(), (int)6, (char)'0');
        return pid + nr;
    }

    public Optional<IAccountTransaction> getAccountTransaction(IPayment payment) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IAccountTransaction.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IACCOUNT_TRANSACTION__PAYMENT, IQuery.COMPARATOR.EQUALS, (Object)payment);
        return query.executeSingleResult();
    }

    public void removePayment(IPayment payment) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IAccountTransaction.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IACCOUNT_TRANSACTION__PAYMENT, IQuery.COMPARATOR.EQUALS, (Object)payment);
        CoreModelServiceHolder.get().remove(query.execute());
        if (payment.getInvoice() != null) {
            payment.getInvoice().addTrace("Korrektur", "Zahlung gel\u00f6scht");
        }
        CoreModelServiceHolder.get().delete((Deleteable)payment);
    }

    public IPayment addPayment(IInvoice invoice, Money amount, String remark, boolean modifyState) {
        Money oldOpen = invoice.getOpenAmount();
        InvoiceState oldInvoiceState = invoice.getState();
        IPayment payment = (IPayment)new IPaymentBuilder(CoreModelServiceHolder.get(), invoice, amount, remark).buildAndSave();
        new IAccountTransactionBuilder(CoreModelServiceHolder.get(), payment).buildAndSave();
        if (modifyState) {
            Money newOffen = invoice.getOpenAmount();
            if (newOffen.isNeglectable()) {
                invoice.setState(InvoiceState.PAID);
            } else if (newOffen.isNegative()) {
                invoice.setState(InvoiceState.EXCESSIVE_PAYMENT);
            } else if (newOffen.getCents() < oldOpen.getCents()) {
                invoice.setState(InvoiceState.PARTIAL_PAYMENT);
            }
            if (invoice.getState() != oldInvoiceState) {
                CoreModelServiceHolder.get().save((Identifiable)invoice);
            }
        }
        return payment;
    }
}

