/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IAccount;
import ch.elexis.core.services.IAccountService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.internal.Account;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AccountService
implements IAccountService {
    private static final String ACCOUNTS_CONFIG = "ch.elexis.core.data/accounttransaction/accounts";
    private static final String ACCOUNTS_SEPARATOR = "||";
    public Account UNKNOWN = new Account(-1, "");
    private HashMap<Integer, IAccount> localCache;
    @Reference
    private IConfigService configService;

    private List<IAccount> loadAccounts() {
        ArrayList<IAccount> ret = new ArrayList<IAccount>();
        ret.add(this.UNKNOWN);
        String accountsString = this.configService.get(ACCOUNTS_CONFIG, "");
        if (accountsString != null && !accountsString.isEmpty()) {
            String[] accounts;
            String[] stringArray = accounts = accountsString.split("\\|\\|");
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] parts = string.split("\\|");
                if (parts.length == 2) {
                    ret.add(new Account(Integer.parseInt(parts[0]), parts[1]));
                }
                ++n2;
            }
        }
        return ret;
    }

    public HashMap<Integer, IAccount> getAccounts() {
        if (this.localCache == null) {
            this.loadCache();
        }
        return this.localCache;
    }

    private void loadCache() {
        this.localCache = new HashMap();
        List<IAccount> accounts = this.loadAccounts();
        for (IAccount account : accounts) {
            this.localCache.put(account.getNumeric(), account);
        }
    }

    public void removeAccount(IAccount account) {
        List<IAccount> accounts = this.loadAccounts();
        Iterator<IAccount> iterator = accounts.iterator();
        while (iterator.hasNext()) {
            Account existingAccount = (Account)iterator.next();
            if (existingAccount.getNumeric() != account.getNumeric()) continue;
            iterator.remove();
        }
        this.setAccounts(accounts);
    }

    public void addAccount(IAccount newAccount) {
        String existingString = this.configService.get(ACCOUNTS_CONFIG, "");
        StringBuilder sb = new StringBuilder();
        sb.append(existingString);
        if (sb.length() > 0) {
            sb.append(ACCOUNTS_SEPARATOR);
        }
        sb.append(newAccount.getNumeric()).append("|").append(newAccount.getName());
        this.configService.set(ACCOUNTS_CONFIG, sb.toString());
        this.loadCache();
    }

    public void setAccounts(List<IAccount> accounts) {
        StringBuilder sb = new StringBuilder();
        for (IAccount account : accounts) {
            if (account.getNumeric() == -1) continue;
            if (sb.length() > 0) {
                sb.append(ACCOUNTS_SEPARATOR);
            }
            sb.append(account.getNumeric()).append("|").append(account.getName());
        }
        this.configService.set(ACCOUNTS_CONFIG, sb.toString());
        this.loadCache();
    }

    public void initDefaults() {
        HashMap<Integer, IAccount> existingAccounts = this.getAccounts();
        if (!existingAccounts.containsKey(1000)) {
            this.addAccount(new Account(1000, "Kasse"));
        }
        if (!existingAccounts.containsKey(1100)) {
            this.addAccount(new Account(1100, "Post"));
        }
        if (!existingAccounts.containsKey(1200)) {
            this.addAccount(new Account(1200, "BESR"));
        }
        if (!existingAccounts.containsKey(1201)) {
            this.addAccount(new Account(1201, "Manuelle Bankeing\u00e4nge"));
        }
        if (!existingAccounts.containsKey(1209)) {
            this.addAccount(new Account(1209, "EFT-Zahlungen"));
        }
        if (!existingAccounts.containsKey(4590)) {
            this.addAccount(new Account(4590, "Differenz"));
        }
        if (!existingAccounts.containsKey(4595)) {
            this.addAccount(new Account(4595, "Debitorenverlust"));
        }
        if (!existingAccounts.containsKey(6060)) {
            this.addAccount(new Account(6060, "Mahngeb\u00fchren (Ertrag)"));
        }
        if (!existingAccounts.containsKey(9999)) {
            this.addAccount(new Account(9999, "Diverses"));
        }
    }

    public IAccount getUnknown() {
        return this.UNKNOWN;
    }
}

