/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.oauth2;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.eenv.ElexisEnvironmentService;
import ch.elexis.core.services.oauth2.AccessTokenUtil;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.time.TimeUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshAccessTokenTimerTask
extends TimerTask {
    private final IContextService contextService;
    private final Logger logger;
    private final ElexisEnvironmentService eeService;

    public RefreshAccessTokenTimerTask(IContextService contextService, ElexisEnvironmentService eeService) {
        this.contextService = contextService;
        this.eeService = eeService;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void run() {
        this.contextService.getTyped(AccessToken.class).ifPresent(this::refreshAccessToken);
    }

    private void refreshAccessToken(AccessToken accessToken) {
        Optional activeUser = this.contextService.getActiveUser();
        if (!activeUser.isPresent()) {
            this.contextService.removeTyped(AccessToken.class);
            this.logger.warn("Found access-token but no active user. Removed access-token.");
            return;
        }
        String activeUserId = ((IUser)activeUser.get()).getId();
        if (!StringUtils.equalsIgnoreCase((CharSequence)activeUserId, (CharSequence)accessToken.getUsername())) {
            this.contextService.removeTyped(AccessToken.class);
            this.logger.warn("Found access-token for user [{}] but active user id [{}]. Removed access-token.", (Object)accessToken.getUsername(), (Object)activeUserId);
            return;
        }
        long accessTokenTimeLeft = accessToken.getAccessTokenExpiration().getTime() - new Date().getTime();
        if (accessTokenTimeLeft <= 60000L) {
            String rcpClientSecret = this.eeService.getProperty("EE_RCP_OPENID_SECRET");
            ObjectStatus<AccessToken> _accessToken = AccessTokenUtil.invokeRefresh(accessToken, rcpClientSecret);
            if (_accessToken.isOK()) {
                this.contextService.setTyped(_accessToken.getObject());
                this.logger.info("RT Refreshed access-token for [{}], valid until [{}], refresh until [{}]", new Object[]{activeUserId, TimeUtil.toLocalDateTime((Date)((AccessToken)_accessToken.get()).getAccessTokenExpiration()), TimeUtil.toLocalDateTime((Date)((AccessToken)_accessToken.get()).refreshTokenExpiration())});
                return;
            }
            this.logger.info("RT Could not refresh: {}", (Object)_accessToken.getMessage());
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("title", "EE Login expired");
            eventMap.put("message", "Your EE login expired, please re-login to Elexis");
            this.logger.warn("Re-Login required, user informed");
            this.contextService.sendEvent("info/elexis/notification/warn", null, eventMap);
        }
    }
}

