/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal.text;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.services.IContext;
import ch.elexis.core.text.ITextPlaceholderResolver;
import ch.elexis.core.text.PlaceholderAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component
public class ImageTextPlaceholderResolver
implements ITextPlaceholderResolver {
    public String getSupportedType() {
        return "Image";
    }

    public List<PlaceholderAttribute> getSupportedAttributes() {
        return Arrays.asList(ImageAttribute.values()).stream().map(m -> new PlaceholderAttribute(this.getSupportedType(), m.name(), m.getLocaleText())).collect(Collectors.toList());
    }

    public Optional<String> replaceByTypeAndAttribute(IContext context, String attribute) {
        return Optional.ofNullable(this.replace(attribute.toLowerCase()));
    }

    private String replace(String lcAttribute) {
        ImageAttribute imageAttribut = (ImageAttribute)this.searchEnum(ImageAttribute.class, lcAttribute);
        if (imageAttribut != null) {
            switch (imageAttribut) {
                case MailPraxisLogo: {
                    return "<img src=\"cid:elexismailpraxislogo\" />";
                }
                case MailAppointmentQr: {
                    return "<img src=\"cid:elexismailappointmentqr\" />";
                }
            }
            return null;
        }
        return null;
    }

    private static enum ImageAttribute implements ILocalizedEnum
    {
        MailPraxisLogo("Ein Praxis Logo f\u00fcr e-mails"),
        MailAppointmentQr("QR code eines Termins");

        final String description;

        private ImageAttribute(String description) {
            this.description = description;
        }

        public String getLocaleText() {
            return this.description;
        }
    }
}

