/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.model.IUser;
import ch.elexis.core.services.ILoginContributor;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.Optional;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"id=login.envvars"})
public class EnvVarsLoginContributor
implements ILoginContributor {
    private Optional<IUser> dbUser;

    public int getPriority() {
        return 1000;
    }

    public IUser performLogin(Object shell) throws LoginException {
        String username = System.getProperty("ch.elexis.username");
        String password = System.getProperty("ch.elexis.password");
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            LoggerFactory.getLogger(this.getClass()).warn("Bypassing LoginDialog with username " + username);
            AccessControlServiceHolder.get().doPrivileged(() -> {
                this.dbUser = CoreModelServiceHolder.get().load(username, IUser.class);
            });
            if (this.dbUser.isPresent()) {
                IUser user = this.dbUser.get().login(username, password.toCharArray());
                if (user != null && user.isActive()) {
                    return user;
                }
                LoggerFactory.getLogger(this.getClass()).error("Authentication failed.");
            }
        }
        return null;
    }
}

