/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.eenv;

import ch.elexis.core.ee.json.WellKnownRcp;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.oauth2.OAuth2Service;
import ch.elexis.core.services.oauth2.RefreshAccessTokenTimerTask;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisEnvironmentService
implements IElexisEnvironmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String elexisEnvironmentHost;
    private IContextService contextService;
    private IConfigService configService;
    private Timer refreshAccessTokenTimer;

    public ElexisEnvironmentService(String elexisEnvironmentHost, IContextService contextService, IConfigService configService) {
        this.elexisEnvironmentHost = elexisEnvironmentHost;
        this.contextService = contextService;
        this.configService = configService;
        LoggerFactory.getLogger(this.getClass()).info("Binding to EE {}", (Object)this.getHostname());
        this.refreshAccessTokenTimer = new Timer("Refresh EE access-token", true);
        this.refreshAccessTokenTimer.schedule((TimerTask)new RefreshAccessTokenTimerTask(contextService, this), 60000L, 60000L);
    }

    public String getVersion() {
        return "unknown";
    }

    public String getProperty(String key) {
        String value = System.getenv(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        return this.configService.get(key, null);
    }

    public WellKnownRcp getWellKnownRcp() {
        HttpClient client = (HttpClient)OsgiServiceUtil.getService(HttpClient.class).get();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getBaseUrl() + "/.well-known/elexis-rcp")).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            WellKnownRcp wellKnownRcp = (WellKnownRcp)new Gson().fromJson(response.body(), WellKnownRcp.class);
            return wellKnownRcp;
        }
        catch (IOException | InterruptedException e) {
            this.logger.warn("Error obtaining /.well-known/elexis-rcp returning defaults", (Throwable)e);
        }
        finally {
            OsgiServiceUtil.ungetService((Object)client);
        }
        return new WellKnownRcp();
    }

    public JsonObject getStatus() {
        HttpClient client = (HttpClient)OsgiServiceUtil.getService(HttpClient.class).get();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.getBaseUrl() + "/.status.json")).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject jsonObject = JsonParser.parseString((String)response.body()).getAsJsonObject();
            return jsonObject;
        }
        catch (IOException | InterruptedException e) {
            this.logger.warn("Error obtaining status", (Throwable)e);
        }
        finally {
            OsgiServiceUtil.ungetService((Object)client);
        }
        return null;
    }

    public String getHostname() {
        return this.elexisEnvironmentHost;
    }

    public void loadAccessToken(String username, char[] password) {
        String rcpClientSecret = this.getProperty("EE_RCP_OPENID_SECRET");
        ObjectStatus<AccessToken> accessToken = new OAuth2Service().performDirectAccessGrantFlow(URI.create(this.getKeycloakRealmEndpoint()), "elexis-rcp-openid", rcpClientSecret, username, password);
        if (accessToken.isOK()) {
            this.contextService.getRootContext().setTyped(accessToken.getObject());
            this.logger.info("Loaded access-token for [{}], valid until [{}], refresh until [{}]", new Object[]{((AccessToken)accessToken.getObject()).getUsername(), TimeUtil.toLocalDateTime((Date)((AccessToken)accessToken.getObject()).getAccessTokenExpiration()), TimeUtil.toLocalDateTime((Date)((AccessToken)accessToken.getObject()).refreshTokenExpiration())});
        } else {
            this.logger.warn("Could not load accessToken: " + accessToken.getMessage());
        }
    }
}

