/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.internal.VirtualFilesystemHandle;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class VirtualFilesystemService
implements IVirtualFilesystemService {
    @Reference
    private IContextService contextService;

    public IVirtualFilesystemService.IVirtualFilesystemHandle of(String uriString, boolean performVariableReplacement) throws IOException {
        try {
            String _uriString = uriString;
            if (performVariableReplacement) {
                _uriString = this.performVariableReplacement(_uriString);
            }
            URI uri = IVirtualFilesystemService.stringToURI((String)_uriString);
            return new VirtualFilesystemHandle(uri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IOException("Error handling uri string [" + uriString + "]", e);
        }
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle of(File file) throws IOException {
        if (file == null) {
            return null;
        }
        URI uri = file.toURI();
        return new VirtualFilesystemHandle(uri);
    }

    private String performVariableReplacement(String uriString) {
        if (uriString.startsWith("davs") && (uriString = uriString.replace("%7B", "{").replace("%7D", "}")).contains("{ctx")) {
            AccessToken accessToken = this.contextService.getTyped(AccessToken.class).orElse(null);
            if (accessToken != null) {
                uriString = uriString.replace("{ctx.access-token}", accessToken.getToken()).replace("{ctx.preferred-username}", accessToken.getUsername());
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("No access-token for replacement in url [{}] found, or no davs url", (Object)uriString);
            }
        }
        return uriString;
    }
}

