/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IOutputLog;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.OrderHistoryAction;
import ch.elexis.core.model.OrderHistoryEntry;
import ch.elexis.core.services.IOrderHistoryService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderHistoryService
implements IOrderHistoryService {
    private static final Logger logger = LoggerFactory.getLogger(OrderHistoryService.class);

    public void logCreateOrder(IOrder order) {
        this.logOrderStatus(order, OrderHistoryAction.CREATED, null);
    }

    public void logEdit(IOrder order, IOrderEntry entry, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        String details = entry.getArticle().getLabel() + " changed from " + oldValue + " to " + newValue;
        this.logOrderStatus(order, OrderHistoryAction.EDITED, details);
    }

    public void logDelivery(IOrder order, IOrderEntry entry, int deliveredAmount, int orderAmaunt) {
        String details = deliveredAmount + "x von " + orderAmaunt + " " + entry.getArticle().getLabel();
        this.logOrderStatus(order, OrderHistoryAction.DELIVERED, details);
    }

    public void logCreateEntry(IOrder order, IOrderEntry entry, int quantity) {
        String details = entry.getArticle().getLabel() + "/" + quantity;
        this.logOrderStatus(order, OrderHistoryAction.ADDMEDI, details);
    }

    public void logOrder(IOrder order) {
        this.logOrderStatus(order, OrderHistoryAction.ORDERED, null);
    }

    public void logDelete(IOrder order) {
        this.logOrderStatus(order, OrderHistoryAction.DELETED, null);
    }

    public void logChangedAmount(IOrder order, IOrderEntry entry, int oldAmount, int newAmount) {
        String details;
        OrderHistoryAction action;
        if (oldAmount == newAmount) {
            return;
        }
        String articleLabel = entry.getArticle().getLabel();
        if (oldAmount == 0) {
            action = OrderHistoryAction.ADDED;
            details = articleLabel + " (Neu: " + newAmount + ")";
        } else if (newAmount > oldAmount) {
            int diff = newAmount - oldAmount;
            action = OrderHistoryAction.INCREASED;
            details = articleLabel + " (" + oldAmount + " \u2192 " + newAmount + ", +" + diff + ")";
        } else {
            int diff = oldAmount - newAmount;
            action = OrderHistoryAction.DECREASED;
            details = articleLabel + " (" + oldAmount + " \u2192 " + newAmount + ", -" + diff + ")";
        }
        this.logOrderStatus(order, action, details);
    }

    public void logCompleteDelivery(IOrder order) {
        if (order == null) {
            return;
        }
        String details = Messages.BestellView_OrderIsClosed;
        this.logOrderStatus(order, OrderHistoryAction.COMPLETEDELIVERY, details);
    }

    public void logRemove(IOrder order, IOrderEntry entry) {
        if (order == null || entry == null) {
            return;
        }
        String details = entry.getArticle().getLabel() + "/" + entry.getAmount();
        this.logOrderStatus(order, OrderHistoryAction.REMOVEDMEDI, details);
    }

    public void logOrderSent(IOrder order, boolean sent) {
        if (order == null) {
            return;
        }
        String method = sent ? Messages.Outputter_Sent : "Printed";
        this.logOrderStatus(order, OrderHistoryAction.ORDERED, method);
    }

    public void logSupplierAdded(IOrder order, IOrderEntry entry, String supplier) {
        if (order == null || entry == null || supplier == null || supplier.isEmpty()) {
            return;
        }
        String details = entry.getArticle().getLabel();
        this.logOrderStatus(order, OrderHistoryAction.SUPPLIERADDED, details, supplier);
    }

    private void logOrderStatus(IOrder order, OrderHistoryAction action, String details) {
        this.logOrderStatus(order, action, details, null);
    }

    private void logOrderStatus(IOrder order, OrderHistoryAction action, String details, String extraInfo) {
        if (order == null) {
            return;
        }
        String userId = ContextServiceHolder.get().getActiveUser().map(user -> user.getId()).orElse("Unknown");
        OrderHistoryEntry entry = new OrderHistoryEntry(action, userId, details, extraInfo);
        this.saveLogEntry(order, entry);
    }

    private void saveLogEntry(IOrder order, OrderHistoryEntry entry) {
        boolean exists;
        if (order == null) {
            return;
        }
        IQuery query = CoreModelServiceHolder.get().getQuery(IOutputLog.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IOUTPUT_LOG__OBJECT_ID, IQuery.COMPARATOR.EQUALS, (Object)order.getId());
        IOutputLog existingLog = query.execute().isEmpty() ? null : (IOutputLog)query.execute().get(0);
        Gson gson = new Gson();
        List<Object> logList = new ArrayList<OrderHistoryEntry>();
        if (existingLog != null) {
            String existingJson = existingLog.getOutputterStatus();
            try {
                JsonElement jsonElement = JsonParser.parseString((String)existingJson);
                if (jsonElement.isJsonArray()) {
                    logList = (List)gson.fromJson(jsonElement, new TypeToken<List<OrderHistoryEntry>>(){}.getType());
                }
            }
            catch (Exception e2) {
                logger.error("Error when parsing the existing logs: " + e2.getMessage());
            }
        }
        if (!(exists = logList.stream().anyMatch(e -> e.getAction() != null && e.getAction().equals((Object)entry.getAction()) && e.getUserId().equals(entry.getUserId()) && Objects.equals(e.getDetails(), entry.getDetails()) && Objects.equals(e.getExtraInfo(), entry.getExtraInfo())))) {
            logList.add(entry);
        }
        String updatedJson = gson.toJson(logList);
        if (existingLog != null) {
            existingLog.setOutputterStatus(updatedJson);
            CoreModelServiceHolder.get().save((Identifiable)existingLog);
        } else {
            IOutputLog outputLog = (IOutputLog)CoreModelServiceHolder.get().create(IOutputLog.class);
            outputLog.setObjectId(order.getId());
            outputLog.setObjectType(order.getClass().getName());
            outputLog.setCreatorId(ContextServiceHolder.get().getActiveUser().map(user -> user.getId()).orElse("Unknown"));
            outputLog.setOutputter(OrderHistoryService.class.getName());
            outputLog.setDate(LocalDate.now());
            outputLog.setOutputterStatus(updatedJson);
            CoreModelServiceHolder.get().save((Identifiable)outputLog);
        }
    }
}

