/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.holder;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.Statistics;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CodeElementServiceHolder {
    private static ICodeElementService codeElementService;

    @Reference
    public void setContextService(ICodeElementService codeElementService) {
        CodeElementServiceHolder.codeElementService = codeElementService;
    }

    public static ICodeElementService get() {
        return codeElementService;
    }

    public static Map<Object, Object> createContext() {
        Optional coverage;
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Optional consultation = ContextServiceHolder.get().getRootContext().getTyped(IEncounter.class);
        if (consultation.isPresent()) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, consultation.get());
            ret.put(ICodeElementService.ContextKeys.COVERAGE, ((IEncounter)consultation.get()).getCoverage());
        }
        if (ret.get(ICodeElementService.ContextKeys.COVERAGE) == null && (coverage = ContextServiceHolder.get().getRootContext().getTyped(ICoverage.class)).isPresent()) {
            ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage.get());
        }
        return ret;
    }

    public static Map<Object, Object> createContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (encounter != null) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
            ICoverage coverage = encounter.getCoverage();
            if (coverage != null) {
                ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
            }
        }
        return ret;
    }

    public static List<Object> getStatistics(String key, IContact contact) {
        CoreModelServiceHolder.get().refresh((Identifiable)contact);
        ArrayList list = (ArrayList)contact.getExtInfo((Object)key);
        if (list != null) {
            return list.stream().map(sl -> StoreToStringServiceHolder.get().loadFromString(sl.getStoreToString()).orElse(null)).filter(o -> o != null && !CodeElementServiceHolder.isDeleted(o)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean isDeleted(Object object) {
        return object instanceof Deleteable && ((Deleteable)object).isDeleted();
    }

    public static void clearStatistics(String key, IContact contact) {
        ArrayList list = (ArrayList)contact.getExtInfo((Object)key);
        if (list != null) {
            list.clear();
            contact.setExtInfo((Object)key, (Object)list);
            CoreModelServiceHolder.get().save((Identifiable)contact);
        }
    }

    public static void updateStatistics(Object element, IContact contact) {
        if (element != null && contact != null) {
            String storeToString = null;
            if (element instanceof Identifiable) {
                storeToString = StoreToStringServiceHolder.get().storeToString((Identifiable)element).orElse(null);
            }
            if (storeToString != null) {
                String key = storeToString.split("::")[0];
                ArrayList<Statistics> list = (ArrayList<Statistics>)contact.getExtInfo((Object)key);
                if (list == null) {
                    list = new ArrayList<Statistics>();
                }
                while (list.size() > 40) {
                    list.remove(list.size() - 1);
                }
                boolean found = false;
                for (Statistics statistic : list) {
                    if (!statistic.getStoreToString().equals(storeToString)) continue;
                    statistic.increase();
                    found = true;
                    break;
                }
                if (!found) {
                    list.add(new Statistics(storeToString));
                }
                Collections.sort(list);
                contact.setExtInfo((Object)key, list);
                CoreModelServiceHolder.get().save((Identifiable)contact);
            }
        }
    }
}

