/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.IMedicationService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IMedicationServiceTest
extends AbstractServiceTest {
    private IMedicationService medicationService = (IMedicationService)OsgiServiceUtil.getService(IMedicationService.class).get();
    private IPatient patient;
    private List<IPrescription> createdPrescriptions;
    private IArticle localArticle;

    @Before
    public void before() {
        this.patient = (IPatient)new IContactBuilder.PatientBuilder(CoreModelServiceHolder.get(), "test", "patient", LocalDate.of(2000, 1, 1), Gender.FEMALE).buildAndSave();
        this.localArticle = (IArticle)new IArticleBuilder(coreModelService, "test medication article", "1234567", ArticleTyp.EIGENARTIKEL).build();
        this.localArticle.setGtin("1111111000000");
        this.localArticle.setPackageSize(2);
        this.localArticle.setSellingSize(1);
        coreModelService.save((Identifiable)this.localArticle);
        this.createdPrescriptions = new ArrayList<IPrescription>();
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, this.patient, "0-1-1-0").entryType(EntryType.FIXED_MEDICATION).buildAndSave());
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, this.patient, "1-0-0-1").entryType(EntryType.SYMPTOMATIC_MEDICATION).buildAndSave());
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, this.patient, "1-0-0-0").entryType(EntryType.RESERVE_MEDICATION).buildAndSave());
        this.createdPrescriptions.add((IPrescription)new IPrescriptionBuilder(coreModelService, null, this.localArticle, this.patient, "0-0-0-1").entryType(EntryType.FIXED_MEDICATION).buildAndSave());
    }

    @After
    public void after() {
        coreModelService.remove(this.createdPrescriptions);
        coreModelService.remove((Identifiable)this.localArticle);
        coreModelService.remove((Identifiable)this.patient);
    }

    @Test
    public void stopPatientPrescriptions() {
        List<IPrescription> prescriptions = this.getPrescriptions(this.patient, "all");
        LocalDateTime now = LocalDateTime.now();
        for (IPrescription iPrescription : prescriptions) {
            this.medicationService.stopPrescription(iPrescription, now, "test reason");
        }
        prescriptions.forEach(pr -> Assert.assertNotNull((Object)pr.getDateTo()));
        this.createdPrescriptions.forEach(pr -> Assert.assertNull((Object)pr.getDateTo()));
        coreModelService.save(prescriptions);
        for (IPrescription iPrescription : prescriptions) {
            Assert.assertEquals((Object)"test reason", (Object)iPrescription.getStopReason());
            Assert.assertNotNull((Object)iPrescription.getDateTo());
        }
        for (IPrescription iPrescription : this.createdPrescriptions) {
            Assert.assertEquals((Object)"test reason", (Object)iPrescription.getStopReason());
            Assert.assertNotNull((Object)iPrescription.getDateTo());
        }
    }

    private List<IPrescription> getPrescriptions(IPatient patient, String medicationType) {
        if ("all".equals(medicationType)) {
            return patient.getMedication(Collections.emptyList());
        }
        if ("fix".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION));
        }
        if ("reserve".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.RESERVE_MEDICATION));
        }
        if ("symptomatic".equals(medicationType)) {
            return patient.getMedication(Arrays.asList(EntryType.SYMPTOMATIC_MEDICATION));
        }
        return Collections.emptyList();
    }
}

