/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IAccountTransaction;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IFreeTextDiagnosis;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IInvoiceBilled;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPayment;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.IInvoiceService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class IInvoiceServiceTest
extends AbstractServiceTest {
    private IBillingService billingService = (IBillingService)OsgiServiceUtil.getService(IBillingService.class).get();
    private IInvoiceService invoiceService = (IInvoiceService)OsgiServiceUtil.getService(IInvoiceService.class).get();
    private static ICustomService customService;

    @BeforeClass
    public static void beforeClass() {
        customService = (ICustomService)coreModelService.create(ICustomService.class);
        customService.setText("test service");
        customService.setCode("1234");
        customService.setNetPrice(new Money(512));
        customService.setPrice(new Money(1024));
        coreModelService.save((Identifiable)customService);
    }

    @Before
    public void before() {
        this.createTestMandantPatientFallBehandlung();
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
    }

    @After
    public void after() {
        ContextServiceHolder.get().setActiveMandator(null);
        this.cleanup();
    }

    @Test
    public void updateInvoiceState() {
        ContextServiceHolder.get().setActiveUser(AllServiceTests.getUser());
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
        ConfigServiceHolder.get().set((IContact)ContextServiceHolder.get().getActiveUserContact().get(), "billing/strict", false);
        Result billed = this.billingService.bill((IBillable)customService, (IEncounter)this.testEncounters.get(0), 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        IFreeTextDiagnosis diagnosis = (IFreeTextDiagnosis)coreModelService.create(IFreeTextDiagnosis.class);
        diagnosis.setDescription("test");
        diagnosis.setText("testText");
        coreModelService.save((Identifiable)diagnosis);
        ((IEncounter)this.testEncounters.get(0)).addDiagnosis((IDiagnosis)diagnosis);
        coreModelService.save((Identifiable)this.testEncounters.get(0));
        Result invoice = this.invoiceService.invoice(this.testEncounters);
        Assert.assertTrue((String)invoice.toString(), (boolean)invoice.isOK());
        IQuery transactionQuery = CoreModelServiceHolder.get().getQuery(IAccountTransaction.class);
        transactionQuery.and((EStructuralFeature)ModelPackage.Literals.IACCOUNT_TRANSACTION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)((IInvoice)invoice.get()).getCoverage().getPatient());
        Assert.assertEquals((long)1L, (long)transactionQuery.execute().size());
        IPayment payment = this.invoiceService.addPayment((IInvoice)invoice.get(), new Money(1024), "test");
        Assert.assertNotNull((Object)payment);
        Assert.assertEquals((double)10.24, (double)((IInvoice)invoice.get()).getPayedAmount().getAmount(), (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)transactionQuery.execute().size());
        Assert.assertEquals((Object)InvoiceState.PAID, (Object)((IInvoice)invoice.get()).getState());
        CoreModelServiceHolder.get().remove((Identifiable)payment);
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
        CoreModelServiceHolder.get().remove((Identifiable)invoice.get());
    }

    @Test
    public void removePayment() {
        ContextServiceHolder.get().setActiveUser(AllServiceTests.getUser());
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
        ConfigServiceHolder.get().set((IContact)ContextServiceHolder.get().getActiveUserContact().get(), "billing/strict", false);
        Result billed = this.billingService.bill((IBillable)customService, (IEncounter)this.testEncounters.get(0), 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        IFreeTextDiagnosis diagnosis = (IFreeTextDiagnosis)coreModelService.create(IFreeTextDiagnosis.class);
        diagnosis.setDescription("test");
        diagnosis.setText("testText");
        coreModelService.save((Identifiable)diagnosis);
        ((IEncounter)this.testEncounters.get(0)).addDiagnosis((IDiagnosis)diagnosis);
        coreModelService.save((Identifiable)this.testEncounters.get(0));
        Result invoice = this.invoiceService.invoice(this.testEncounters);
        Assert.assertTrue((String)invoice.toString(), (boolean)invoice.isOK());
        IQuery transactionQuery = CoreModelServiceHolder.get().getQuery(IAccountTransaction.class);
        transactionQuery.and((EStructuralFeature)ModelPackage.Literals.IACCOUNT_TRANSACTION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)((IInvoice)invoice.get()).getCoverage().getPatient());
        Assert.assertEquals((long)1L, (long)transactionQuery.execute().size());
        IPayment payment = this.invoiceService.addPayment((IInvoice)invoice.get(), new Money(128), "test");
        Assert.assertNotNull((Object)payment);
        Assert.assertEquals((double)1.28, (double)((IInvoice)invoice.get()).getPayedAmount().getAmount(), (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)transactionQuery.execute().size());
        Assert.assertEquals((Object)InvoiceState.PARTIAL_PAYMENT, (Object)((IInvoice)invoice.get()).getState());
        this.invoiceService.removePayment(payment);
        Assert.assertEquals((double)0.0, (double)((IInvoice)invoice.get()).getPayedAmount().getAmount(), (double)1.0E-4);
        Assert.assertEquals((long)1L, (long)transactionQuery.execute().size());
        CoreModelServiceHolder.get().remove((Identifiable)payment);
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
        CoreModelServiceHolder.get().remove((Identifiable)invoice.get());
    }

    @Test
    public void getInvoiceCancel() {
        ContextServiceHolder.get().setActiveUser(AllServiceTests.getUser());
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
        ConfigServiceHolder.get().set((IContact)ContextServiceHolder.get().getActiveUserContact().get(), "billing/strict", false);
        Result billed = this.billingService.bill((IBillable)customService, (IEncounter)this.testEncounters.get(0), 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        IFreeTextDiagnosis diagnosis = (IFreeTextDiagnosis)coreModelService.create(IFreeTextDiagnosis.class);
        diagnosis.setDescription("test");
        diagnosis.setText("testText");
        coreModelService.save((Identifiable)diagnosis);
        ((IEncounter)this.testEncounters.get(0)).addDiagnosis((IDiagnosis)diagnosis);
        coreModelService.save((Identifiable)this.testEncounters.get(0));
        Result invoice = this.invoiceService.invoice(this.testEncounters);
        Assert.assertTrue((String)invoice.toString(), (boolean)invoice.isOK());
        IQuery transactionQuery = CoreModelServiceHolder.get().getQuery(IAccountTransaction.class);
        transactionQuery.and("invoice", IQuery.COMPARATOR.EQUALS, invoice.get());
        List transactions = transactionQuery.execute();
        IQuery paymentQuery = CoreModelServiceHolder.get().getQuery(IPayment.class);
        paymentQuery.and("invoice", IQuery.COMPARATOR.EQUALS, invoice.get());
        List payments = paymentQuery.execute();
        Assert.assertEquals((long)1L, (long)transactions.size());
        Assert.assertEquals((long)0L, (long)payments.size());
        this.invoiceService.cancel((IInvoice)invoice.get(), true);
        transactions = transactionQuery.execute();
        payments = paymentQuery.execute();
        Assert.assertEquals((long)2L, (long)transactions.size());
        Assert.assertEquals((long)1L, (long)payments.size());
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
        List invoices = this.invoiceService.getInvoices((IEncounter)this.testEncounters.get(0));
        Assert.assertEquals((long)1L, (long)invoices.size());
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
        invoices.forEach(i -> CoreModelServiceHolder.get().remove((Identifiable)i));
    }

    @Test
    public void getInvoices() {
        ContextServiceHolder.get().setActiveUser(AllServiceTests.getUser());
        ContextServiceHolder.get().setActiveMandator((IMandator)this.testMandators.get(0));
        ConfigServiceHolder.get().set((IContact)ContextServiceHolder.get().getActiveUserContact().get(), "billing/strict", false);
        Result billed = this.billingService.bill((IBillable)customService, (IEncounter)this.testEncounters.get(0), 1.0);
        Assert.assertTrue((String)((Result.msg)billed.getMessages().get(0)).getText(), (boolean)billed.isOK());
        IFreeTextDiagnosis diagnosis = (IFreeTextDiagnosis)coreModelService.create(IFreeTextDiagnosis.class);
        diagnosis.setDescription("test");
        diagnosis.setText("testText");
        coreModelService.save((Identifiable)diagnosis);
        ((IEncounter)this.testEncounters.get(0)).addDiagnosis((IDiagnosis)diagnosis);
        coreModelService.save((Identifiable)this.testEncounters.get(0));
        Result invoice = this.invoiceService.invoice(this.testEncounters);
        Assert.assertTrue((String)invoice.toString(), (boolean)invoice.isOK());
        this.invoiceService.cancel((IInvoice)invoice.get(), true);
        invoice = this.invoiceService.invoice(this.testEncounters);
        List invoices = this.invoiceService.getInvoices((IEncounter)this.testEncounters.get(0));
        Assert.assertEquals((long)2L, (long)invoices.size());
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IInvoiceBilled.class, new String[]{"encounter"});
        List invoicebilled = query.executeWithParameters(query.getParameterMap(new Object[]{"encounter", this.testEncounters.get(0)}));
        ((IInvoiceBilled)invoicebilled.get(0)).setInvoice(null);
        coreModelService.save((Identifiable)invoicebilled.get(0));
        invoices = this.invoiceService.getInvoices((IEncounter)this.testEncounters.get(0));
        Assert.assertEquals((long)1L, (long)invoices.size());
        CoreModelServiceHolder.get().remove((Identifiable)billed.get());
        invoices.forEach(i -> CoreModelServiceHolder.get().remove((Identifiable)i));
    }
}

