/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.vfs.AbstractVirtualFileHandle_Webdav_Test;
import ch.elexis.core.services.vfs.AssumingWebdavConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class VirtualFileHandle_WebdavDirectory_Test
extends AbstractVirtualFileHandle_Webdav_Test {
    private IVirtualFilesystemService.IVirtualFilesystemHandle directoryHandle;
    @ClassRule
    public static AssumingWebdavConnection assumingWebdavConnection = new AssumingWebdavConnection("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/");

    @BeforeClass
    public static void beforeClass() throws IOException {
        AbstractVirtualFileHandle_Webdav_Test.beforeClass();
    }

    @Before
    public void initialize() throws IOException {
        this.directoryHandle = service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/testDirectory/");
        Assert.assertNotNull((Object)this.directoryHandle);
    }

    @Test
    public void a_mkdir() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle dirHandle = this.directoryHandle.mkdir();
        Assert.assertEquals((Object)this.directoryHandle.getAbsolutePath(), (Object)dirHandle.getAbsolutePath());
    }

    @Test
    public void b_isDirectory() throws IOException {
        Assert.assertTrue((boolean)this.directoryHandle.isDirectory());
    }

    @Test(expected=IOException.class)
    public void c_writeFails() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (OutputStream outputStream = this.directoryHandle.openOutputStream();){
            IOUtils.write((byte[])randomBytes, (OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expected=IOException.class)
    public void d_openInputStreamFails() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = this.directoryHandle.openInputStream();){
            byte[] byteArray = IOUtils.toByteArray((InputStream)is);
            Assert.assertArrayEquals((byte[])randomBytes, (byte[])byteArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void e_getContentLengthFails() throws IOException {
        Assert.assertEquals((long)-1L, (long)this.directoryHandle.getContentLenght());
    }

    @Test
    public void f_getNameExtension() {
        Assert.assertEquals((Object)"testDirectory", (Object)this.directoryHandle.getName());
    }

    @Test
    public void g_existsCanReadCanWrite() throws IOException {
        Assert.assertTrue((boolean)this.directoryHandle.exists());
        Assert.assertTrue((boolean)this.directoryHandle.canRead());
        Assert.assertTrue((boolean)this.directoryHandle.canWrite());
    }

    @Test
    public void ha_list() throws IOException {
        this.directoryHandle.subFile("listingTestFile.txt").writeAllBytes(randomBytes);
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = this.directoryHandle.listHandles();
        Assert.assertEquals((long)1L, (long)listHandles.length);
        Assert.assertEquals((Object)"listingTestFile.txt", (Object)listHandles[0].getName());
        Assert.assertTrue((boolean)listHandles[0].canWrite());
        listHandles[0].delete();
        Assert.assertFalse((boolean)listHandles[0].exists());
    }

    @Test
    public void hb_listWithFilter() throws IOException {
        this.directoryHandle.subFile("listingTestFile.abc").writeAllBytes(randomBytes);
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = this.directoryHandle.listHandles(handle -> {
            String extension = handle.getExtension();
            boolean result = "abc".equalsIgnoreCase(extension);
            return result;
        });
        Assert.assertEquals((long)1L, (long)listHandles.length);
        Assert.assertEquals((Object)"listingTestFile.abc", (Object)listHandles[0].getName());
        Assert.assertTrue((boolean)listHandles[0].canWrite());
        listHandles[0].delete();
        Assert.assertFalse((boolean)listHandles[0].exists());
    }

    @Test
    public void i_delete() throws IOException {
        Assert.assertTrue((boolean)this.directoryHandle.exists());
        Assert.assertTrue((boolean)this.directoryHandle.isDirectory());
        this.directoryHandle.delete();
        Assert.assertFalse((boolean)this.directoryHandle.exists());
    }

    @Test
    public void j_subDir() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle subDir = this.directoryHandle.subDir("testSubDir");
        Assert.assertEquals((Object)(this.directoryHandle.getAbsolutePath() + "testSubDir/"), (Object)subDir.getAbsolutePath());
        Assert.assertFalse((boolean)subDir.exists());
    }

    @Test
    public void k_subFile() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle subFile = this.directoryHandle.subFile("testSubFile");
        Assert.assertEquals((Object)(this.directoryHandle.getAbsolutePath() + "testSubFile"), (Object)subFile.getAbsolutePath());
    }

    @Test
    public void l_getParent() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle parent = this.directoryHandle.getParent();
        Assert.assertEquals((Object)service.of("dav://admin:admin@localhost:22808/remote.php/dav/files/admin/").toURL(), (Object)parent.getURI().toURL());
    }
}

