/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.exceptions.AccessControlException;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IRole;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.builder.IUserBuilder;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.services.holder.UserServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RoleBasedAccessControlServiceTest {
    private IModelService modelService = AllServiceTests.getModelService();
    private static IAccessControlService accessControlService;
    private static IContextService contextService;
    private static IUser medicalPractitioner;
    private static IUser medicalUser;
    private static IUser mpaUser;

    @BeforeClass
    public static void beforeClass() {
        accessControlService = (IAccessControlService)OsgiServiceUtil.getService(IAccessControlService.class).get();
        contextService = (IContextService)OsgiServiceUtil.getService(IContextService.class).get();
        IContactBuilder.PersonBuilder personBuilder = new IContactBuilder.PersonBuilder(CoreModelServiceHolder.get(), "medical", "practitioner", LocalDate.of(2000, 1, 1), Gender.FEMALE).mandator();
        medicalPractitioner = (IUser)new IUserBuilder(CoreModelServiceHolder.get(), "medicalpractitioner", (IContact)personBuilder.buildAndSave()).buildAndSave();
        medicalPractitioner.addRole((IRole)CoreModelServiceHolder.get().load("medical-practitioner", IRole.class).get());
        personBuilder = new IContactBuilder.PersonBuilder(CoreModelServiceHolder.get(), "medical", "user", LocalDate.of(2000, 1, 1), Gender.FEMALE).mandator();
        medicalUser = (IUser)new IUserBuilder(CoreModelServiceHolder.get(), "medicaluser", (IContact)personBuilder.buildAndSave()).buildAndSave();
        medicalUser.addRole((IRole)CoreModelServiceHolder.get().load("medical-user", IRole.class).get());
        personBuilder = new IContactBuilder.PersonBuilder(CoreModelServiceHolder.get(), "mpa", "user", LocalDate.of(2000, 1, 1), Gender.FEMALE);
        mpaUser = (IUser)new IUserBuilder(CoreModelServiceHolder.get(), "mpauser", (IContact)personBuilder.buildAndSave()).buildAndSave();
        mpaUser.addRole((IRole)CoreModelServiceHolder.get().load("mpa", IRole.class).get());
        IUserService userService = UserServiceHolder.get();
        userService.addOrRemoveExecutiveDoctorWorkingFor(mpaUser, (IMandator)CoreModelServiceHolder.get().load(medicalPractitioner.getAssignedContact().getId(), IMandator.class).get(), true);
        userService.addOrRemoveExecutiveDoctorWorkingFor(mpaUser, (IMandator)CoreModelServiceHolder.get().load(medicalUser.getAssignedContact().getId(), IMandator.class).get(), true);
        contextService.getRootContext().setNamed("testAccessControl", (Object)Boolean.TRUE);
    }

    @AfterClass
    public static void afterClass() {
        contextService.getRootContext().setNamed("testAccessControl", null);
        CoreModelServiceHolder.get().remove((Identifiable)mpaUser.getAssignedContact());
        CoreModelServiceHolder.get().remove((Identifiable)mpaUser);
        CoreModelServiceHolder.get().remove((Identifiable)medicalUser.getAssignedContact());
        CoreModelServiceHolder.get().remove((Identifiable)medicalUser);
        CoreModelServiceHolder.get().remove((Identifiable)medicalPractitioner.getAssignedContact());
        CoreModelServiceHolder.get().remove((Identifiable)medicalPractitioner);
    }

    @Test
    public void userHasSystemCommandRightToLogin() {
        Assert.assertTrue((boolean)accessControlService.evaluate(EvACE.of((String)"ch.elexis.core.ui.login")));
        Assert.assertFalse((boolean)accessControlService.evaluate(EvACE.of((String)"some-invalid-command")));
    }

    @Test
    public void userHasNoRightToLoadPatients() {
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.READ)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.VIEW)));
        Optional patient = this.modelService.load(AllServiceTests.getPatient().getId(), IPatient.class);
        Assert.assertTrue((boolean)patient.isEmpty());
        IQuery query = this.modelService.getQuery(IPatient.class);
        query.limit(10);
        List execute = query.execute();
        Assert.assertTrue((boolean)execute.isEmpty());
    }

    @Test(expected=AccessControlException.class)
    public void userHasNoRightToCreatePatient() {
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.CREATE)));
        CoreModelServiceHolder.get().create(IPatient.class);
    }

    @Test(expected=AccessControlException.class)
    public void userHasNoRightToRemoveOrganization() {
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IOrganization.class, (Right)Right.READ)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IOrganization.class, (Right)Right.REMOVE)));
        Optional load = CoreModelServiceHolder.get().load(AllServiceTests.getLaboratory().getId(), IOrganization.class);
        CoreModelServiceHolder.get().remove((Identifiable)load.get());
    }

    @Test
    public void userHasRightToLoadOrganizationAndLaboratory() {
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IOrganization.class, (Right)Right.READ)));
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IOrganization.class, (Right)Right.VIEW)));
        Optional laboratory = this.modelService.load(AllServiceTests.getLaboratory().getId(), ILaboratory.class);
        Assert.assertTrue((boolean)laboratory.isPresent());
    }

    @Test(expected=AccessControlException.class)
    public void userHasNoRightToDeleteLaboratory() {
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(ILaboratory.class, (Right)Right.READ)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(ILaboratory.class, (Right)Right.DELETE)));
        Optional load = CoreModelServiceHolder.get().load(AllServiceTests.getLaboratory().getId(), ILaboratory.class);
        CoreModelServiceHolder.get().delete((Deleteable)load.get());
    }

    @Test
    public void userHasNoRightToLoadPerson() {
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPerson.class, (Right)Right.READ)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPerson.class, (Right)Right.VIEW)));
        Optional load = CoreModelServiceHolder.get().load(AllServiceTests.getPatient().getId(), IPerson.class);
        Assert.assertFalse((boolean)load.isPresent());
    }

    @Test(expected=AccessControlException.class)
    public void userHasNoRightToUpdateArticle() {
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IArticle.class, (Right)Right.READ)));
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IArticle.class, (Right)Right.VIEW)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IArticle.class, (Right)Right.UPDATE)));
        IArticle iArticle = (IArticle)CoreModelServiceHolder.get().load(AllServiceTests.getEigenartikel().getId(), IArticle.class).get();
        iArticle.setName("this-should-not-work");
        CoreModelServiceHolder.get().save((Identifiable)iArticle);
        CoreModelServiceHolder.get().touch((Identifiable)iArticle);
    }

    @Test(expected=AccessControlException.class)
    public void userHasNoRightToTouchArticle() {
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IArticle.class, (Right)Right.READ)));
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IArticle.class, (Right)Right.VIEW)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IArticle.class, (Right)Right.UPDATE)));
        IArticle iArticle = (IArticle)CoreModelServiceHolder.get().load(AllServiceTests.getEigenartikel().getId(), IArticle.class).get();
        CoreModelServiceHolder.get().touch((Identifiable)iArticle);
    }

    @Test
    public void namedQueryExecution() {
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.READ)));
        INamedQuery namedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
        List found = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"code", AllServiceTests.getPatient().getPatientNr()}));
        Assert.assertTrue((boolean)found.isEmpty());
    }

    @Test
    public void executePrivileged() {
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.READ)));
        accessControlService.doPrivileged(() -> {
            INamedQuery privilegedNamedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
            List privilegedfound = privilegedNamedQuery.executeWithParameters(privilegedNamedQuery.getParameterMap(new Object[]{"code", AllServiceTests.getPatient().getPatientNr()}));
            Assert.assertFalse((boolean)privilegedfound.isEmpty());
        });
        INamedQuery namedQuery = CoreModelServiceHolder.get().getNamedQuery(IPatient.class, new String[]{"code"});
        List found = namedQuery.executeWithParameters(namedQuery.getParameterMap(new Object[]{"code", AllServiceTests.getPatient().getPatientNr()}));
        Assert.assertTrue((boolean)found.isEmpty());
    }

    @Test
    public void medicalPractitionerRole() {
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IRole.class, (Right)Right.READ)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPerson.class, (Right)Right.READ)));
        Assert.assertFalse((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IEncounter.class, (Right)Right.READ)));
        IRole role = (IRole)CoreModelServiceHolder.get().load("medical-practitioner", IRole.class).get();
        IUser user = (IUser)contextService.getActiveUser().get();
        user.addRole(role);
        accessControlService.refresh(user);
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IPerson.class, (Right)Right.READ)));
        Assert.assertTrue((boolean)accessControlService.evaluate((EvaluatableACE)EvACE.of(IEncounter.class, (Right)Right.READ)));
        user.removeRole(role);
    }

    @Test
    public void aobo() {
        IUser user = (IUser)contextService.getActiveUser().get();
        contextService.setActiveUser(medicalPractitioner);
        IEncounter practitionerEncounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), AllServiceTests.getCoverage(), (IMandator)CoreModelServiceHolder.get().load(medicalPractitioner.getAssignedContact().getId(), IMandator.class).get()).buildAndSave();
        contextService.setActiveUser(mpaUser);
        Assert.assertTrue((boolean)accessControlService.evaluate(EvACE.of(IEncounter.class, (Right)Right.READ, (String)StoreToStringServiceHolder.getStoreToString((Object)practitionerEncounter))));
        contextService.setActiveUser(medicalUser);
        Assert.assertFalse((boolean)accessControlService.evaluate(EvACE.of(IEncounter.class, (Right)Right.READ, (String)StoreToStringServiceHolder.getStoreToString((Object)practitionerEncounter))));
        contextService.setActiveUser(medicalUser);
        IMandator medicalUserMandator = (IMandator)CoreModelServiceHolder.get().load(medicalUser.getAssignedContact().getId(), IMandator.class).get();
        IEncounter medicalUserEncounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), AllServiceTests.getCoverage(), medicalUserMandator).buildAndSave();
        medicalUserMandator.setActive(false);
        CoreModelServiceHolder.get().save((Identifiable)medicalUserMandator);
        UserServiceHolder.get().addOrRemoveExecutiveDoctorWorkingFor(mpaUser, (IMandator)CoreModelServiceHolder.get().load(medicalUser.getAssignedContact().getId(), IMandator.class).get(), true);
        contextService.setActiveUser(mpaUser);
        Assert.assertTrue((boolean)accessControlService.evaluate(EvACE.of(IEncounter.class, (Right)Right.READ, (String)StoreToStringServiceHolder.getStoreToString((Object)medicalUserEncounter))));
        accessControlService.doPrivileged(() -> {
            CoreModelServiceHolder.get().remove((Identifiable)practitionerEncounter);
            CoreModelServiceHolder.get().remove((Identifiable)medicalUserEncounter);
        });
        contextService.setActiveUser(user);
    }
}

