/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ICoverageServiceTest
extends AbstractServiceTest {
    private ICoverageService coverageService = (ICoverageService)OsgiServiceUtil.getService(ICoverageService.class).get();
    ICoverage coverage;
    IPatient patient;

    @Before
    public void before() {
        this.createTestMandantPatientFallBehandlung();
        this.patient = (IPatient)this.testPatients.get(0);
        for (ICoverage existingCoverages : this.patient.getCoverages()) {
            coreModelService.remove((Identifiable)existingCoverages);
        }
    }

    @After
    public void after() {
        this.cleanup();
    }

    @Test
    public void getLatestEncounter() throws InterruptedException {
        IEncounter encounter = (IEncounter)new IEncounterBuilder(coreModelService, (ICoverage)this.testCoverages.get(0), (IMandator)this.testMandators.get(0)).buildAndSave();
        encounter.setTimeStamp(LocalDateTime.now().plusDays(1L));
        coreModelService.save((Identifiable)encounter);
        Optional latestEncounter = this.coverageService.getLatestEncounter((ICoverage)this.testCoverages.get(0));
        Assert.assertTrue((boolean)latestEncounter.isPresent());
        Assert.assertEquals((Object)encounter, latestEncounter.get());
        coreModelService.remove((Identifiable)encounter);
    }

    @Test
    public void testGetCoverageWithLawNoMatch() {
        this.coverage = new ICoverageBuilder(coreModelService, this.patient, this.coverageService.getDefaultCoverageLabel(), this.coverageService.getDefaultCoverageReason(), "KGV").buildAndSave();
        Optional result = this.coverageService.getCoverageWithLaw(this.patient, new BillingLaw[]{BillingLaw.privat});
        Assert.assertTrue((boolean)result.isEmpty());
        coreModelService.remove((Identifiable)this.coverage);
    }

    @Test
    public void testGetCoverageWithLawNoOpenCoverage() {
        this.coverage = new ICoverageBuilder(coreModelService, this.patient, this.coverageService.getDefaultCoverageLabel(), this.coverageService.getDefaultCoverageReason(), "KGV").buildAndSave();
        this.coverage.setDateTo(LocalDate.now());
        coreModelService.save((Identifiable)this.coverage);
        Optional result = this.coverageService.getCoverageWithLaw(this.patient, new BillingLaw[]{BillingLaw.KVG});
        Assert.assertTrue((boolean)result.isEmpty());
        coreModelService.remove((Identifiable)this.coverage);
    }

    @Test
    public void testGetCoverageWithLawHasCoverage() {
        this.coverage = new ICoverageBuilder(coreModelService, this.patient, this.coverageService.getDefaultCoverageLabel(), this.coverageService.getDefaultCoverageReason(), "KGV").buildAndSave();
        Optional coverageWithLaw = this.coverageService.getCoverageWithLaw(this.patient, new BillingLaw[]{BillingLaw.KVG});
        Assert.assertTrue((boolean)coverageWithLaw.isPresent());
        coreModelService.remove((Identifiable)this.coverage);
    }
}

