/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.Gender;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class IStockServiceTest
extends AbstractServiceTest {
    static IModelService coreModelService = AllServiceTests.getModelService();
    private static IStockService service;
    private static IPatient patient;
    private static IArticle article;

    @BeforeClass
    public static void beforeClass() {
        service = (IStockService)OsgiServiceUtil.getService(IStockService.class).get();
        patient = (IPatient)new IContactBuilder.PatientBuilder(coreModelService, "test", "patient", LocalDate.of(2000, 1, 1), Gender.MALE).buildAndSave();
        article = (IArticle)new IArticleBuilder(coreModelService, "test medication article", "1234567", ArticleTyp.ARTIKELSTAMM).buildAndSave();
    }

    @Test
    public void a_createPatientStock() {
        service.setEnablePatientStock(patient, true);
        IStock stock = (IStock)service.getPatientStock(patient).get();
        Assert.assertEquals((long)0L, (long)stock.getPriority());
        Assert.assertEquals((Object)("PatientStock-" + patient.getPatientNr()), (Object)stock.getId());
        Assert.assertEquals((Object)("P" + patient.getPatientNr()), (Object)stock.getCode());
        Assert.assertEquals((Object)"patient test", (Object)stock.getDescription());
        Assert.assertEquals((Object)"Patient", (Object)stock.getLocation());
        Assert.assertFalse((boolean)stock.isDeleted());
        IStockEntry stockEntry = service.storeArticleInStock(stock, StoreToStringServiceHolder.getStoreToString((Object)article));
        Assert.assertEquals((Object)article, (Object)stockEntry.getArticle());
        Assert.assertEquals((long)1L, (long)stockEntry.getCurrentStock());
    }

    @Test
    public void b_deletePatientStock() {
        IStock patientStock = (IStock)service.getPatientStock(patient).get();
        List stockEntries = service.findAllStockEntriesForStock(patientStock);
        Assert.assertEquals((Object)article, (Object)((IStockEntry)stockEntries.get(0)).getArticle());
        Assert.assertEquals((long)1L, (long)((IStockEntry)stockEntries.get(0)).getCurrentStock());
        Assert.assertEquals((Object)patientStock, (Object)((IStockEntry)stockEntries.get(0)).getStock());
        service.setEnablePatientStock(patient, false);
        Assert.assertFalse((boolean)service.getPatientStock(patient).isPresent());
        List entries = service.findAllStockEntriesForStock(patientStock);
        Assert.assertTrue((boolean)entries.isEmpty());
    }
}

