/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.services.AbstractServiceTest;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IBillingService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IOrderServiceTest
extends AbstractServiceTest {
    static IModelService coreModelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
    private static IOrderService orderService;
    private static IArticle article;
    private static IStock stock;
    private static IStockEntry stockEntry;
    private static IOrder order;

    @BeforeClass
    public static void beforeClass() {
        orderService = (IOrderService)OsgiServiceUtil.getService(IOrderService.class).get();
        article = (IArticle)new IArticleBuilder(coreModelService, "test medication article", "1234567", ArticleTyp.ARTIKELSTAMM).buildAndSave();
        stock = IOrderServiceTest.createStock();
        stockEntry = IOrderServiceTest.createStockEntry();
        order = IOrderServiceTest.createOrder();
    }

    @Test
    public void addRefillForStockEntryToOrder() {
        IOrderEntry newEntry = orderService.addRefillForStockEntryToOrder(stockEntry, order);
        Assert.assertNotNull((Object)newEntry);
        Assert.assertEquals((Object)stockEntry.getArticle(), (Object)newEntry.getArticle());
        Assert.assertEquals((long)2L, (long)newEntry.getAmount());
    }

    @Test
    public void findOpenOrderEntryForStockEntry() {
        IOrderEntry entry = orderService.findOpenOrderEntryForStockEntry(stockEntry);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals(order.getEntries().get(0), (Object)entry);
    }

    @Test
    public void findOrderEntryForStock() {
        IOrderEntry orderEntry = (IOrderEntry)order.getEntries().get(0);
        orderEntry.setState(OrderEntryState.DONE);
        List entries = orderService.findOrderEntryForStock(stock);
        Assert.assertFalse((boolean)entries.isEmpty());
        Assert.assertTrue((boolean)entries.contains(orderEntry));
    }

    private static IStock createStock() {
        IStock stock = (IStock)coreModelService.create(IStock.class);
        stock.setCode("TES");
        stock.setPriority(1);
        stock.setDescription("Test");
        coreModelService.save((Identifiable)stock);
        return stock;
    }

    private static IStockEntry createStockEntry() {
        IStockEntry stockEntry = (IStockEntry)coreModelService.create(IStockEntry.class);
        stockEntry.setStock(stock);
        stockEntry.setCurrentStock(0);
        stockEntry.setMaximumStock(1);
        stockEntry.setArticle(article);
        return stockEntry;
    }

    private static IOrder createOrder() {
        IOrder order = (IOrder)coreModelService.create(IOrder.class);
        coreModelService.save((Identifiable)order);
        coreModelService.save((Identifiable)order.addEntry(article, stock, null, 1));
        return order;
    }

    @Test
    public void calculateDailyDifferences_shouldCalculateCorrectDiff() {
        IMandator mandator = AllServiceTests.getMandator();
        ContextServiceHolder.get().setActiveMandator(mandator);
        IArticle testArticle = (IArticle)new IArticleBuilder(coreModelService, "Testartikel", "9999999", ArticleTyp.EIGENARTIKEL).buildAndSave();
        IEncounter encounter = (IEncounter)coreModelService.create(IEncounter.class);
        encounter.setDate(LocalDate.now());
        encounter.setMandator(mandator);
        encounter.setBillable(true);
        coreModelService.save((Identifiable)encounter);
        IBillingService billingService = (IBillingService)OsgiServiceUtil.getService(IBillingService.class).get();
        billingService.bill((IBillable)testArticle, encounter, 5.0);
        IOrder order = (IOrder)coreModelService.create(IOrder.class);
        IOrderEntry entry = order.addEntry(testArticle, stock, null, 2);
        entry.setState(OrderEntryState.OPEN);
        coreModelService.save((Identifiable)order);
        coreModelService.save((Identifiable)entry);
        Map differences = orderService.calculateDailyDifferences(LocalDate.now(), List.of(mandator));
        Assert.assertNotNull((Object)differences);
        Assert.assertTrue((boolean)differences.containsKey(testArticle));
        Assert.assertEquals((Object)3, differences.get(testArticle));
    }

    @Test
    public void reduceOpenEntries() {
        IOrder freshOrder = (IOrder)coreModelService.create(IOrder.class);
        coreModelService.save((Identifiable)freshOrder);
        IOrderEntry entry = freshOrder.addEntry(article, stock, null, 4);
        entry.setState(OrderEntryState.OPEN);
        coreModelService.save((Identifiable)entry);
        orderService.reduceOpenEntries(List.of(freshOrder), article, 3);
        IOrderEntry updated = freshOrder.getEntries().stream().filter(e -> e.getId().equals(entry.getId())).findFirst().orElse(null);
        Assert.assertNotNull((Object)updated);
        Assert.assertEquals((long)1L, (long)updated.getAmount());
    }

    @Test
    public void createOrderEntries() {
        order.getEntries().forEach(e -> {
            e.setState(OrderEntryState.DONE);
            coreModelService.save((Identifiable)e);
        });
        LinkedHashMap<IArticle, Integer> toCreate = new LinkedHashMap<IArticle, Integer>();
        toCreate.put(article, 3);
        int initialCount = order.getEntries().size();
        orderService.addOrCreateOrderEntries(List.of(order), order, toCreate, null);
        Assert.assertEquals((long)(initialCount + 1), (long)order.getEntries().size());
        IOrderEntry added = (IOrderEntry)order.getEntries().get(order.getEntries().size() - 1);
        Assert.assertEquals((Object)article, (Object)added.getArticle());
        Assert.assertEquals((long)3L, (long)added.getAmount());
    }
}

