/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IContactBuilder;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.AllServiceTests;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.types.Gender;
import ch.rgw.tools.TimeTool;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractServiceTest {
    static IModelService coreModelService = AllServiceTests.getModelService();
    public List<IMandator> testMandators = new ArrayList<IMandator>();
    public List<IPatient> testPatients = new ArrayList<IPatient>();
    public List<ICoverage> testCoverages = new ArrayList<ICoverage>();
    public List<IEncounter> testEncounters = new ArrayList<IEncounter>();

    public void createTestMandantPatientFallBehandlung() {
        TimeTool timeTool = new TimeTool();
        IPerson _mandator = (IPerson)new IContactBuilder.PersonBuilder(coreModelService, "mandator1 " + timeTool.toString(), "Anton" + timeTool.toString(), timeTool.toLocalDate(), Gender.MALE).mandator().buildAndSave();
        IMandator mandator = (IMandator)coreModelService.load(_mandator.getId(), IMandator.class).get();
        this.testMandators.add(mandator);
        IPatient patient = (IPatient)new IContactBuilder.PatientBuilder(coreModelService, "Armer", "Anton" + timeTool.toString(), timeTool.toLocalDate(), Gender.MALE).buildAndSave();
        this.testPatients.add(patient);
        ICoverage testCoverage = new ICoverageBuilder(coreModelService, patient, "Fallbezeichnung", "Fallgrund", "KVG").buildAndSave();
        testCoverage.setExtInfo((Object)"Versicherungsnummer", (Object)"12340815");
        coreModelService.save((Identifiable)testCoverage);
        this.testCoverages.add(testCoverage);
        IEncounter behandlung = (IEncounter)new IEncounterBuilder(coreModelService, testCoverage, mandator).buildAndSave();
        this.testEncounters.add(behandlung);
    }

    public void cleanup() {
        for (IEncounter iEncounter : this.testEncounters) {
            coreModelService.remove((Identifiable)iEncounter);
        }
        this.testEncounters.clear();
        for (ICoverage iCoverage : this.testCoverages) {
            coreModelService.remove((Identifiable)iCoverage);
        }
        this.testCoverages.clear();
        for (IContact iContact : this.testPatients) {
            coreModelService.remove((Identifiable)iContact);
        }
        this.testPatients.clear();
        for (IMandator iMandator : this.testMandators) {
            IMandator activeMandator;
            if (iMandator.equals(activeMandator = (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null))) {
                ContextServiceHolder.get().setActiveMandator(null);
            }
            coreModelService.remove((Identifiable)iMandator);
        }
        this.testMandators.clear();
    }

    public static void acceptAllCerts() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }
}

